'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _Base = require('./Base');

var _Base2 = _interopRequireDefault(_Base);

var _Label = require('./Label');

var _Label2 = _interopRequireDefault(_Label);

var _Text = require('./Text');

var _Text2 = _interopRequireDefault(_Text);

var _config = require('./config');

var _config2 = _interopRequireDefault(_config);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

/**
 * Input element with label with support for aria-invalid, disabled, and readOnly HTML attributes
 */

var Input = function Input(_ref, _ref2) {
  var label = _ref.label;
  var name = _ref.name;
  var type = _ref.type;
  var message = _ref.message;
  var hideLabel = _ref.hideLabel;
  var children = _ref.children;

  var props = _objectWithoutProperties(_ref, ['label', 'name', 'type', 'message', 'hideLabel', 'children']);

  var rebass = _ref2.rebass;

  var _config$rebass = _extends({}, _config2.default, rebass);

  var scale = _config$rebass.scale;
  var colors = _config$rebass.colors;
  var borderColor = _config$rebass.borderColor;


  var invalid = props.invalid || props['aria-invalid'];

  var _props = props;
  var rounded = _props.rounded;
  var backgroundColor = _props.backgroundColor;
  var theme = _props.theme;
  var inverted = _props.inverted;

  var rootProps = _objectWithoutProperties(_props, ['rounded', 'backgroundColor', 'theme', 'inverted']);

  var sx = {
    root: {
      marginBottom: scale[2],
      color: invalid ? colors.error : null
    },
    input: {
      fontFamily: 'inherit',
      fontSize: 'inherit',
      boxSizing: 'border-box',
      display: 'block',
      width: '100%',
      height: scale[3],
      margin: 0,
      color: 'inherit',
      backgroundColor: 'rgba(255, 255, 255, .25)',
      borderWidth: 1,
      borderStyle: 'solid',
      borderColor: invalid ? colors.error : borderColor
    }
  };

  var cx = (0, _classnames2.default)('Input', {
    'isInvalid': invalid,
    'isDisabled': props.disabled,
    'isReadonly': props.readOnly
  });

  return _react2.default.createElement(
    _Base2.default,
    _extends({}, rootProps, {
      className: cx,
      baseStyle: sx.root }),
    _react2.default.createElement(_Label2.default, {
      htmlFor: name,
      hide: hideLabel,
      children: label }),
    _react2.default.createElement(_Base2.default, _extends({}, props, {
      tagName: 'input',
      type: type,
      name: name,
      rounded: rounded,
      backgroundColor: backgroundColor,
      theme: theme,
      inverted: inverted,
      m: 0,
      mx: 0,
      my: 0,
      p: 0,
      px: 1,
      py: 0,
      baseStyle: sx.input })),
    message && _react2.default.createElement(_Text2.default, { small: true, children: message })
  );
};

Input.propTypes = {
  /** Label for form element */
  label: _react2.default.PropTypes.string.isRequired,
  /** Name attribute for form element */
  name: _react2.default.PropTypes.string.isRequired,
  /** Form element type */
  type: _react2.default.PropTypes.string,
  /** Adds a helper or error message below the input */
  message: _react2.default.PropTypes.string,
  /** Hides the form element label */
  hideLabel: _react2.default.PropTypes.bool,
  /** Controls the border radius for creating grouped elements */
  rounded: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.bool, _react2.default.PropTypes.oneOf(['top', 'right', 'bottom', 'left'])])
};

Input.defaultProps = {
  type: 'text',
  rounded: true
};

Input.contextTypes = {
  rebass: _react2.default.PropTypes.object
};

exports.default = Input;