'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Label = require('./Label');

var _Label2 = _interopRequireDefault(_Label);

var _Base = require('./Base');

var _Base2 = _interopRequireDefault(_Base);

var _config = require('./config');

var _config2 = _interopRequireDefault(_config);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

/**
 * Input type range with label
 */

var InputRange = function InputRange(_ref, _ref2) {
  var label = _ref.label;
  var name = _ref.name;
  var hideLabel = _ref.hideLabel;
  var children = _ref.children;

  var props = _objectWithoutProperties(_ref, ['label', 'name', 'hideLabel', 'children']);

  var rebass = _ref2.rebass;

  var _config$rebass = _extends({}, _config2.default, rebass);

  var scale = _config$rebass.scale;


  var css = '\n    .InputRange-input::-webkit-slider-thumb {\n      width: 8px;\n      height: 20px;\n      margin-top: -8px;\n      background-color: currentcolor;\n      border: 0;\n      border-radius: 4px;\n      -webkit-appearance: none;\n    }\n    .InputRange-input::-moz-range-thumb {\n      width: 8px;\n      height: 20px;\n      margin-top: -8px;\n      background-color: currentcolor;\n      border: 0;\n      border-radius: 4px;\n      -webkit-appearance: none;\n    }\n    .InputRange-input::-webkit-slider-runnable-track {\n      height: 4px;\n      border-radius: 2px;\n      background-color: rgba(0, 0, 0, .25);\n    }\n    .InputRange-input::-moz-range-track {\n      height: 4px;\n      border-radius: 2px;\n      background-color: rgba(0, 0, 0, .25);\n    }\n  '.replace(/\n/g, '').replace(/\s\s+/g, ' ');

  return _react2.default.createElement(
    _Base2.default,
    _extends({}, props, {
      className: 'InputRange',
      baseStyle: {
        marginBottom: scale[2]
      } }),
    _react2.default.createElement('style', { dangerouslySetInnerHTML: { __html: css } }),
    _react2.default.createElement(_Label2.default, {
      htmlFor: name,
      hide: hideLabel,
      children: label }),
    _react2.default.createElement('input', _extends({}, props, {
      type: 'range',
      name: name,
      className: 'InputRange-input',
      style: {
        boxSizing: 'border-box',
        display: 'block',
        width: '100%',
        margin: 0,
        paddingTop: 8,
        paddingBottom: 8,
        cursor: 'pointer',
        color: 'inherit',
        backgroundColor: 'transparent',
        WebkitAppearance: 'none',
        appearance: 'none'
      } }))
  );
};

InputRange.propTypes = {
  /** Label for form element */
  label: _react2.default.PropTypes.string.isRequired,
  /** Name attribute for form element */
  name: _react2.default.PropTypes.string.isRequired,
  /** Hides the form element label */
  hideLabel: _react2.default.PropTypes.bool
};

InputRange.contextTypes = {
  rebass: _react2.default.PropTypes.object
};

exports.default = InputRange;