'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var monospace = '"Roboto Mono", Menlo, Consolas, monospace';

var baseColors = {
  black: '#111',
  white: '#fff',
  gray: '#ddd',
  midgray: '#888',
  blue: '#08e',
  red: '#f52',
  orange: '#f70',
  green: '#1c7'
};

var colors = _extends({}, baseColors, {
  primary: baseColors.blue,
  secondary: baseColors.midgray,
  default: baseColors.black,
  info: baseColors.blue,
  success: baseColors.green,
  warning: baseColors.orange,
  error: baseColors.red
});

var inverted = colors.white;

var scale = [0, 8, 16, 32, 64];

var fontSizes = [48, 32, 24, 20, 16, 14, 12];

var zIndex = [0, 2, 4, 8, 16];

var bold = 600;
var borderRadius = 2;
var borderColor = 'rgba(0, 0, 0, .25)';

var config = {
  scale: scale,
  fontSizes: fontSizes,
  bold: bold,
  monospace: monospace,
  zIndex: zIndex,
  colors: colors,
  inverted: inverted,
  borderRadius: borderRadius,
  borderColor: borderColor,
  pureRender: true
};

exports.default = config;