'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var monospace = '\'Roboto Mono\', Menlo, Consolas, monospace';

var baseColors = {
  black: '#111',
  white: '#fff',
  gray: '#ccc',
  midgray: '#777',
  blue: '#08e',
  red: '#f52',
  orange: '#f90',
  green: '#1c7'
};

// darken: 'rgba(0, 0, 0, .9375)',
// lighten: 'rgba(255, 255, 255, .9375)',
var colors = _extends({}, baseColors, {
  primary: baseColors.blue,
  secondary: baseColors.midgray,
  default: baseColors.black,
  info: baseColors.blue,
  success: baseColors.green,
  warning: baseColors.orange,
  error: baseColors.red
});

var scale = [0, 8, 16, 32, 64];

var fontSizes = [48, 32, 24, 20, 16, 14, 12];

var zIndex = [0, 2, 4, 8, 16];

var bold = 600;
var borderRadius = 2;
var borderColor = 'rgba(0, 0, 0, .25)';

var theme = {
  scale: scale,
  fontSizes: fontSizes,
  bold: bold,
  monospace: monospace,
  zIndex: zIndex,
  colors: colors,
  borderRadius: borderRadius,
  borderColor: borderColor
};

exports.default = theme;