import { ReCaptchaInstance } from './ReCaptchaInstance';
declare class ReCaptchaLoader {
    private static loadingState;
    private static instance;
    private static instanceSiteKey;
    private static successfulLoadingConsumers;
    private static errorLoadingRunnable;
    private static readonly SCRIPT_LOAD_DELAY;
    static load(siteKey: string, options?: IReCaptchaLoaderOptions): Promise<ReCaptchaInstance>;
    static getInstance(): ReCaptchaInstance;
    private static setLoadingState;
    private static getLoadingState;
    private loadScript;
    private buildQueryString;
    private waitForScriptToLoad;
    private doExplicitRender;
}
export interface IReCaptchaLoaderOptions {
    useRecaptchaNet?: boolean;
    useEnterprise?: boolean;
    autoHideBadge?: boolean;
    renderParameters?: {
        [key: string]: string;
    };
    explicitRenderParameters?: IReCaptchaExplicitRenderParameters;
    customUrl?: string;
}
export interface IReCaptchaExplicitRenderParameters {
    container?: string | Element;
    badge?: 'bottomright' | 'bottomleft' | 'inline';
    size?: 'invisible';
    tabindex?: number;
}
export declare const load: typeof ReCaptchaLoader.load;
export declare const getInstance: typeof ReCaptchaLoader.getInstance;
export {};
