declare global {
    const grecaptcha: IReCaptchaInstance;
    interface Window {
        grecaptcha: IReCaptchaInstance;
    }
}
export interface IReCaptchaInstance {
    ready(callback: () => void): void;
    execute(siteKey: string, options: IExecuteOptions): Promise<string>;
    render(container: string | Element, parameters: IRenderParameters): string;
    render(parameters: IRenderParameters): string;
    enterprise: Omit<IReCaptchaInstance, 'enterprise'>;
}
export declare interface IExecuteOptions {
    action?: string;
}
export declare interface IRenderParameters {
    sitekey: string;
    badge?: 'bottomright' | 'bottomleft' | 'inline';
    size?: 'invisible';
    tabindex?: number;
}
