require('keyboardevent-key-polyfill');

// these are the only relevant modifiers supported on all platforms,
// according to MDN:
// <https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/getModifierState>
const MODIFIERS = {
  'Alt':      'altKey',
  'Control':  'ctrlKey',
  'Ctrl':     'ctrlKey',
  'Shift':    'shiftKey'
};

const MODIFIER_SEPARATOR = '+';

const getEventKey = function(event, hasModifiers) {
  var key = event.key;
  if (hasModifiers) {
    for (var modifier in MODIFIERS) {
      if (event[MODIFIERS[modifier]] === true) {
        key = [modifier, key].join(MODIFIER_SEPARATOR);
      }
    }
  }
  return key;
};

module.exports = function keymap(keys) {
  const hasModifiers = Object.keys(keys).some(function(key) {
    return key.indexOf(MODIFIER_SEPARATOR) > -1;
  });
  return function(event) {
    var key = getEventKey(event, hasModifiers);
    return [key, key.toLowerCase()]
      .reduce(function(result, _key) {
        if (_key in keys) {
          result = keys[key].call(this, event);
        }
        return result;
      }, undefined);
  };
};

module.exports.MODIFIERS = MODIFIERS;
