'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _createHelper = require('./createHelper');

var _createHelper2 = _interopRequireDefault(_createHelper);

var createSpy = function createSpy() {
  var spyInfo = [];

  function addSpyInstance(spyInstance) {
    spyInfo.unshift({
      _spy: spyInstance,
      component: null,
      props: []
    });
  }

  function removeSpyInstance(spyInstance) {
    spyInfo = spyInfo.filter(function (s) {
      return s._spy !== spyInstance;
    });
  }

  function receiveProps(spyInstance, props) {
    var info = spyInfo.find(function (s) {
      return s._spy === spyInstance;
    });

    if (!info) return;

    info.props.unshift(props);
  }

  function updateComponent(spyInstance, component) {
    var info = spyInfo.find(function (s) {
      return s._spy === spyInstance;
    });

    if (!info) return;

    info.component = component;
  }

  var spy = _createHelper2['default'](function (BaseComponent) {
    return (function (_React$Component) {
      _inherits(_class, _React$Component);

      function _class(props, context) {
        var _this = this;

        _classCallCheck(this, _class);

        _React$Component.call(this, props, context);

        this.refCallback = function (ref) {
          return updateComponent(_this, ref);
        };

        addSpyInstance(this);
        receiveProps(this, props);
      }

      _class.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
        receiveProps(this, nextProps);
      };

      _class.prototype.componentWillUnmount = function componentWillUnmount() {
        removeSpyInstance(this);
      };

      _class.prototype.render = function render() {
        return _react2['default'].createElement(BaseComponent, _extends({}, this.props, { ref: this.refCallback }));
      };

      return _class;
    })(_react2['default'].Component);
  }, 'spy');

  spy.getInfo = function () {
    return spyInfo;
  };
  spy.getProps = function () {
    var componentIndex = arguments.length <= 0 || arguments[0] === undefined ? 0 : arguments[0];
    var renderIndex = arguments.length <= 1 || arguments[1] === undefined ? 0 : arguments[1];
    return spyInfo[componentIndex].props[renderIndex];
  };
  spy.getRenderCount = function () {
    var componentIndex = arguments.length <= 0 || arguments[0] === undefined ? 0 : arguments[0];
    return spyInfo[componentIndex].props.length;
  };
  spy.getComponent = function () {
    var componentIndex = arguments.length <= 0 || arguments[0] === undefined ? 0 : arguments[0];
    return spyInfo[componentIndex].component;
  };

  return spy;
};

exports['default'] = createSpy;
module.exports = exports['default'];