'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createElement = require('./createElement');

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var nest = function nest() {
  for (var _len = arguments.length, Components = Array(_len), _key = 0; _key < _len; _key++) {
    Components[_key] = arguments[_key];
  }

  var createElements = Components.map(_createElement.internalCreateElement);
  var Nest = function Nest(_ref) {
    var props = _objectWithoutProperties(_ref, []);

    var children = _ref.children;
    return createElements.reduceRight(function (child, createElement) {
      return createElement(props, child);
    }, children);
  };

  if (process.env.NODE_ENV !== 'production') {
    var getDisplayName = require('./getDisplayName').default;
    var displayNames = Components.map(getDisplayName);
    Nest.displayName = 'nest(' + displayNames.join(', ') + ')';
  }

  return Nest;
};

exports.default = nest;