'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _createHelper = require('./createHelper');

var _createHelper2 = _interopRequireDefault(_createHelper);

var _createElement = require('./createElement');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var lifecycle = function lifecycle(spec) {
  return function (BaseComponent) {
    var createElement = (0, _createElement.internalCreateElement)(BaseComponent);

    if (process.env.NODE_ENV !== 'production' && spec.hasOwnProperty('render')) {
      console.error('lifecycle() does not support the render method; its behavior is to ' + 'pass all props and state to the base component.');
    }

    return (0, _react.createClass)(_extends({}, spec, {
      render: function render() {
        return createElement(_extends({}, this.props, this.state));
      }
    }));
  };
};

exports.default = (0, _createHelper2.default)(lifecycle, 'lifecycle');