import { ResolvedThemeInterface, ThemeInterface } from '../theme';
import { SideNavStyleEnum } from './types';
import type { LabelsConfigRaw, MDXComponentMeta } from './types';
export type DownloadUrlsConfig = {
    title?: string;
    url: string;
}[];
export interface RedocRawOptions {
    theme?: ThemeInterface;
    scrollYOffset?: number | string | (() => number);
    hideHostname?: boolean | string;
    expandResponses?: string | 'all';
    requiredPropsFirst?: boolean | string;
    sortRequiredPropsFirst?: boolean | string;
    sortPropsAlphabetically?: boolean | string;
    sortEnumValuesAlphabetically?: boolean | string;
    sortOperationsAlphabetically?: boolean | string;
    sortTagsAlphabetically?: boolean | string;
    nativeScrollbars?: boolean | string;
    pathInMiddlePanel?: boolean | string;
    untrustedSpec?: boolean | string;
    sanitize?: boolean | string;
    hideLoading?: boolean | string;
    hideDownloadButton?: boolean | string;
    hideDownloadButtons?: boolean | string;
    downloadFileName?: string;
    downloadDefinitionUrl?: string;
    downloadUrls?: DownloadUrlsConfig;
    disableSearch?: boolean | string;
    onlyRequiredInSamples?: boolean | string;
    showExtensions?: boolean | string | string[];
    sideNavStyle?: SideNavStyleEnum;
    hideSingleRequestSampleTab?: boolean | string;
    hideRequestPayloadSample?: boolean;
    menuToggle?: boolean | string;
    jsonSampleExpandLevel?: number | string | 'all';
    jsonSamplesExpandLevel?: number | string | 'all';
    hideSchemaTitles?: boolean | string;
    simpleOneOfTypeLabel?: boolean | string;
    payloadSampleIdx?: number;
    expandSingleSchemaField?: boolean | string;
    schemaExpansionLevel?: number | string | 'all';
    schemasExpansionLevel?: number | string | 'all';
    schemaDefinitionsTagName?: string;
    showObjectSchemaExamples?: boolean | string;
    showSecuritySchemeType?: boolean;
    hideSecuritySection?: boolean;
    unstable_ignoreMimeParameters?: boolean;
    allowedMdComponents?: Record<string, MDXComponentMeta>;
    labels?: LabelsConfigRaw;
    enumSkipQuotes?: boolean | string;
    expandDefaultServerVariables?: boolean;
    maxDisplayedEnumValues?: number;
    ignoreNamedSchemas?: string[] | string;
    hideSchemaPattern?: boolean;
    generatedPayloadSamplesMaxDepth?: number;
    generatedSamplesMaxDepth?: number;
    nonce?: string;
    hideFab?: boolean;
    minCharacterLengthToInitSearch?: number;
    showWebhookVerb?: boolean;
    hidePropertiesPrefix?: boolean;
}
export declare function argValueToBoolean(val?: string | boolean, defaultValue?: boolean): boolean;
export declare class RedocNormalizedOptions {
    static normalizeExpandResponses(value: RedocRawOptions['expandResponses']): {};
    static normalizeHideHostname(value: RedocRawOptions['hideHostname']): boolean;
    static normalizeScrollYOffset(value: RedocRawOptions['scrollYOffset']): () => number;
    static normalizeShowExtensions(value: RedocRawOptions['showExtensions']): string[] | boolean;
    static normalizeSideNavStyle(value: RedocRawOptions['sideNavStyle']): SideNavStyleEnum;
    static normalizePayloadSampleIdx(value: RedocRawOptions['payloadSampleIdx']): number;
    private static normalizeJsonSampleExpandLevel;
    private static normalizeGeneratedPayloadSamplesMaxDepth;
    theme: ResolvedThemeInterface;
    scrollYOffset: () => number;
    hideHostname: boolean;
    expandResponses: {
        [code: string]: boolean;
    } | 'all';
    sortRequiredPropsFirst: boolean;
    sortPropsAlphabetically: boolean;
    sortEnumValuesAlphabetically: boolean;
    sortOperationsAlphabetically: boolean;
    sortTagsAlphabetically: boolean;
    nativeScrollbars: boolean;
    pathInMiddlePanel: boolean;
    sanitize: boolean;
    hideDownloadButtons: boolean;
    downloadFileName?: string;
    downloadDefinitionUrl?: string;
    downloadUrls?: DownloadUrlsConfig;
    disableSearch: boolean;
    onlyRequiredInSamples: boolean;
    showExtensions: boolean | string[];
    sideNavStyle: SideNavStyleEnum;
    hideSingleRequestSampleTab: boolean;
    hideRequestPayloadSample: boolean;
    menuToggle: boolean;
    jsonSamplesExpandLevel: number;
    enumSkipQuotes: boolean;
    hideSchemaTitles: boolean;
    simpleOneOfTypeLabel: boolean;
    payloadSampleIdx: number;
    expandSingleSchemaField: boolean;
    schemasExpansionLevel: number;
    schemaDefinitionsTagName?: string;
    showObjectSchemaExamples: boolean;
    showSecuritySchemeType?: boolean;
    hideSecuritySection?: boolean;
    unstable_ignoreMimeParameters: boolean;
    allowedMdComponents: Record<string, MDXComponentMeta>;
    expandDefaultServerVariables: boolean;
    maxDisplayedEnumValues?: number;
    ignoreNamedSchemas: Set<string>;
    hideSchemaPattern: boolean;
    generatedSamplesMaxDepth: number;
    hideFab: boolean;
    minCharacterLengthToInitSearch: number;
    showWebhookVerb: boolean;
    hidePropertiesPrefix?: boolean;
    nonce?: string;
    constructor(raw: RedocRawOptions, defaults?: RedocRawOptions);
}
