export const rulesSchema = {
    type: 'object',
    additionalProperties: {
        oneOf: [{ type: 'string' }, { type: 'object' }],
    },
};
export const ruleSchemas = {
    rules: rulesSchema,
    oas2Rules: rulesSchema,
    oas3_0Rules: rulesSchema,
    oas3_1Rules: rulesSchema,
    async2Rules: rulesSchema,
    async3Rules: rulesSchema,
    arazzo1Rules: rulesSchema,
    overlay1Rules: rulesSchema,
};
export const preprocessorSchemas = {
    preprocessors: { type: 'object', additionalProperties: true },
    oas2Preprocessors: { type: 'object', additionalProperties: true },
    oas3_0Preprocessors: { type: 'object', additionalProperties: true },
    oas3_1Preprocessors: { type: 'object', additionalProperties: true },
    async2Preprocessors: { type: 'object', additionalProperties: true },
    async3Preprocessors: { type: 'object', additionalProperties: true },
    arazzo1Preprocessors: { type: 'object', additionalProperties: true },
    overlay1Preprocessors: { type: 'object', additionalProperties: true },
};
export const decoratorsSchemas = {
    decorators: { type: 'object', additionalProperties: true },
    oas2Decorators: { type: 'object', additionalProperties: true },
    oas3_0Decorators: { type: 'object', additionalProperties: true },
    oas3_1Decorators: { type: 'object', additionalProperties: true },
    async2Decorators: { type: 'object', additionalProperties: true },
    async3Decorators: { type: 'object', additionalProperties: true },
    arazzo1Decorators: { type: 'object', additionalProperties: true },
    overlay1Decorators: { type: 'object', additionalProperties: true },
};
//# sourceMappingURL=common.js.map