export const entityCatalogExcludeSchema = {
    type: 'object',
    required: ['key'],
    properties: {
        key: { type: 'string' },
    },
    additionalProperties: false,
};
export const entityCatalogIncludeSchema = {
    type: 'object',
    required: ['type'],
    properties: {
        type: { type: 'string' },
    },
    additionalProperties: false,
};
export const entityCatalogFilterSchema = {
    type: 'object',
    required: ['property', 'title'],
    properties: {
        property: { type: 'string' },
        hide: { type: 'boolean' },
        label: { type: 'string' },
        options: {
            type: 'array',
            items: { type: 'string' },
        },
        type: {
            type: 'string',
            enum: ['select', 'checkboxes', 'date-range'],
            default: 'checkboxes',
        },
        title: { type: 'string' },
        titleTranslationKey: { type: 'string' },
        parentFilter: { type: 'string' },
        valuesMapping: { type: 'object', additionalProperties: { type: 'string' } },
    },
    additionalProperties: false,
};
export const entityCatalogSpecificCatalogSchema = {
    type: 'object',
    properties: {
        slug: { type: 'string' },
        hide: { type: 'boolean' },
        includes: {
            type: 'array',
            items: entityCatalogIncludeSchema,
        },
        excludes: {
            type: 'array',
            items: entityCatalogExcludeSchema,
        },
        filters: {
            type: 'array',
            items: entityCatalogFilterSchema,
        },
        titleTranslationKey: { type: 'string' },
        descriptionTranslationKey: { type: 'string' },
        catalogSwitcherLabelTranslationKey: { type: 'string' },
    },
    additionalProperties: false,
};
export const entitiesCatalogConfigSchema = {
    type: 'object',
    properties: {
        catalogs: {
            type: 'object',
            properties: {
                all: entityCatalogSpecificCatalogSchema,
                services: entityCatalogSpecificCatalogSchema,
                domains: entityCatalogSpecificCatalogSchema,
                teams: entityCatalogSpecificCatalogSchema,
                users: entityCatalogSpecificCatalogSchema,
                apiDescriptions: entityCatalogSpecificCatalogSchema,
                dataSchemas: entityCatalogSpecificCatalogSchema,
                apiOperations: entityCatalogSpecificCatalogSchema,
            },
            additionalProperties: false,
        },
    },
    additionalProperties: false,
};
//# sourceMappingURL=entities-catalog-config-schema.js.map