const jobInputsSchema = {
    type: 'object',
    additionalProperties: { type: 'string' },
};
const jobServersSchema = {
    type: 'object',
    additionalProperties: false,
    patternProperties: {
        '^[a-zA-Z0-9_-]+$': {
            type: 'string',
            pattern: '^https?://[^\\s/$.?#].[^\\s]*$',
        },
    },
};
const severitySchema = {
    type: 'string',
    enum: ['error', 'warn', 'off'],
};
const jobSeveritySchema = {
    type: 'object',
    additionalProperties: false,
    properties: {
        schemaCheck: severitySchema,
        statusCodeCheck: severitySchema,
        contentTypeCheck: severitySchema,
        successCriteriaCheck: severitySchema,
    },
};
const jobTriggerIntervalSchema = {
    type: 'object',
    properties: {
        event: { type: 'string', enum: ['schedule'] },
        interval: {
            type: 'string',
            enum: ['1m', '2m', '5m', '10m', '15m', '30m', '1h', '3h', '6h', '12h', '1d', '7d'],
        },
    },
    required: ['event'],
    additionalProperties: false,
};
const jobTriggerBuildSchema = {
    type: 'object',
    properties: {
        event: { type: 'string', enum: ['build'] },
    },
    required: ['event'],
    additionalProperties: false,
};
export const reuniteConfigSchema = {
    type: 'object',
    properties: {
        ignoreLint: {
            oneOf: [
                { type: 'boolean', default: false },
                {
                    type: 'object',
                    additionalProperties: { type: 'boolean' },
                },
            ],
        },
        ignoreLinkChecker: { type: 'boolean' },
        ignoreMarkdocErrors: { type: 'boolean' },
        ignoreRespectMonitoring: { type: 'boolean' },
        jobs: {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    path: {
                        type: 'string',
                        pattern: '^(?!\\.\\./)(/[a-zA-Z0-9_\\-\\./]+|./[a-zA-Z0-9_\\-\\./]+|[a-zA-Z0-9_\\-\\./]+)$',
                    },
                    agent: {
                        type: 'string',
                        enum: ['respect'],
                    },
                    trigger: {
                        oneOf: [jobTriggerIntervalSchema, jobTriggerBuildSchema],
                    },
                    inputs: jobInputsSchema,
                    servers: jobServersSchema,
                    severity: jobSeveritySchema,
                },
                required: ['path', 'trigger', 'agent'],
                additionalProperties: false,
            },
        },
    },
    additionalProperties: false,
};
//# sourceMappingURL=reunite-config-schema.js.map