"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decoratorsSchemas = exports.preprocessorSchemas = exports.ruleSchemas = exports.rulesSchema = void 0;
exports.rulesSchema = {
    type: 'object',
    additionalProperties: {
        oneOf: [{ type: 'string' }, { type: 'object' }],
    },
};
exports.ruleSchemas = {
    rules: exports.rulesSchema,
    oas2Rules: exports.rulesSchema,
    oas3_0Rules: exports.rulesSchema,
    oas3_1Rules: exports.rulesSchema,
    async2Rules: exports.rulesSchema,
    async3Rules: exports.rulesSchema,
    arazzo1Rules: exports.rulesSchema,
    overlay1Rules: exports.rulesSchema,
};
exports.preprocessorSchemas = {
    preprocessors: { type: 'object', additionalProperties: true },
    oas2Preprocessors: { type: 'object', additionalProperties: true },
    oas3_0Preprocessors: { type: 'object', additionalProperties: true },
    oas3_1Preprocessors: { type: 'object', additionalProperties: true },
    async2Preprocessors: { type: 'object', additionalProperties: true },
    async3Preprocessors: { type: 'object', additionalProperties: true },
    arazzo1Preprocessors: { type: 'object', additionalProperties: true },
    overlay1Preprocessors: { type: 'object', additionalProperties: true },
};
exports.decoratorsSchemas = {
    decorators: { type: 'object', additionalProperties: true },
    oas2Decorators: { type: 'object', additionalProperties: true },
    oas3_0Decorators: { type: 'object', additionalProperties: true },
    oas3_1Decorators: { type: 'object', additionalProperties: true },
    async2Decorators: { type: 'object', additionalProperties: true },
    async3Decorators: { type: 'object', additionalProperties: true },
    arazzo1Decorators: { type: 'object', additionalProperties: true },
    overlay1Decorators: { type: 'object', additionalProperties: true },
};
//# sourceMappingURL=common.js.map