"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.entitiesCatalogConfigSchema = exports.entityCatalogSpecificCatalogSchema = exports.entityCatalogFilterSchema = exports.entityCatalogIncludeSchema = exports.entityCatalogExcludeSchema = void 0;
exports.entityCatalogExcludeSchema = {
    type: 'object',
    required: ['key'],
    properties: {
        key: { type: 'string' },
    },
    additionalProperties: false,
};
exports.entityCatalogIncludeSchema = {
    type: 'object',
    required: ['type'],
    properties: {
        type: { type: 'string' },
    },
    additionalProperties: false,
};
exports.entityCatalogFilterSchema = {
    type: 'object',
    required: ['property', 'title'],
    properties: {
        property: { type: 'string' },
        hide: { type: 'boolean' },
        label: { type: 'string' },
        options: {
            type: 'array',
            items: { type: 'string' },
        },
        type: {
            type: 'string',
            enum: ['select', 'checkboxes', 'date-range'],
            default: 'checkboxes',
        },
        title: { type: 'string' },
        titleTranslationKey: { type: 'string' },
        parentFilter: { type: 'string' },
        valuesMapping: { type: 'object', additionalProperties: { type: 'string' } },
    },
    additionalProperties: false,
};
exports.entityCatalogSpecificCatalogSchema = {
    type: 'object',
    properties: {
        slug: { type: 'string' },
        hide: { type: 'boolean' },
        includes: {
            type: 'array',
            items: exports.entityCatalogIncludeSchema,
        },
        excludes: {
            type: 'array',
            items: exports.entityCatalogExcludeSchema,
        },
        filters: {
            type: 'array',
            items: exports.entityCatalogFilterSchema,
        },
        titleTranslationKey: { type: 'string' },
        descriptionTranslationKey: { type: 'string' },
        catalogSwitcherLabelTranslationKey: { type: 'string' },
    },
    additionalProperties: false,
};
exports.entitiesCatalogConfigSchema = {
    type: 'object',
    properties: {
        catalogs: {
            type: 'object',
            properties: {
                all: exports.entityCatalogSpecificCatalogSchema,
                services: exports.entityCatalogSpecificCatalogSchema,
                domains: exports.entityCatalogSpecificCatalogSchema,
                teams: exports.entityCatalogSpecificCatalogSchema,
                users: exports.entityCatalogSpecificCatalogSchema,
                apiDescriptions: exports.entityCatalogSpecificCatalogSchema,
                dataSchemas: exports.entityCatalogSpecificCatalogSchema,
                apiOperations: exports.entityCatalogSpecificCatalogSchema,
            },
            additionalProperties: false,
        },
    },
    additionalProperties: false,
};
//# sourceMappingURL=entities-catalog-config-schema.js.map