import type { RedoclyConfig } from './config-types';
import type { PageStaticData } from './portal-shared-types';
export type ServerPropsRequest = {
    raw: Request;
    headers: Record<string, any>;
    params: Record<string, any>;
    query: Record<string, any>;
    cookies: Record<string, any>;
    body: ReadableStream<Uint8Array> | null;
};
export type ApiFunctionsContextMethods = {
    status: (code: number) => ApiFunctionsContextMethods;
    setCookie: (name: string, value: string, options?: CookieOptions) => ApiFunctionsContextMethods;
    deleteCookie: (name: string) => ApiFunctionsContextMethods;
    json: (data: object) => Response;
    text: (data: string, code?: number) => Response;
    redirect: (url: string, code?: number) => Response;
};
export type ApiFunctionsContext = {
    user: {
        teams: string[];
        claims: Record<string, any>;
        email: string | undefined;
        idpAccessToken: string | undefined;
        idpId: string | undefined;
        isAuthenticated: boolean;
    };
    config: RedoclyConfig;
    params: Record<string, string | string[]>;
    query: Record<string, string | string[]>;
    cookies: Record<string, string>;
} & ApiFunctionsContextMethods;
export type ApiFunctionsHandler = (request: Request, context: ApiFunctionsContext, 
/**
 * @deprecated `staticData` is deprecated.
 */
staticData: PageStaticData) => Promise<Response>;
export interface CookieOptions {
    domain?: string;
    expires?: Date;
    httpOnly?: boolean;
    maxAge?: number;
    path?: string;
    secure?: boolean;
    signed?: boolean;
    sameSite?: 'Strict' | 'Lax' | 'None';
}
export type ServerPropsContext = ApiFunctionsContext;
