export type CatalogConfigEntityExclude = {
    key: string;
};
export type CatalogConfigEntityInclude = {
    type: string;
};
export type CatalogConfigEntityFilter = {
    title: string;
    titleTranslationKey?: string;
    parentFilter?: string;
    valuesMapping?: Record<string, string>;
    missingCategoryName?: string;
    missingCategoryNameTranslationKey?: string;
    property: string;
    type?: 'select' | 'checkboxes' | 'date-range';
    options?: string[];
    hide?: boolean;
    label?: string;
};
export type CatalogEntityConfig = {
    slug?: string;
    hide?: boolean;
    excludes?: CatalogConfigEntityExclude[];
    includes?: CatalogConfigEntityInclude[];
    filters?: CatalogConfigEntityFilter[];
    titleTranslationKey?: string;
    descriptionTranslationKey?: string;
    catalogSwitcherLabelTranslationKey?: string;
};
