<p align="center">
    <a href="https://redom.js.org/" target="_blank" rel="noopener">
        <img width="220" src="https://redom.js.org/static/images/redomjs.svg" alt="RE:DOM logo">
    </a>
    <br>
    Develop web applications with <strong>100% JavaScript</strong> and web standards. 🚀
</p>
<p align="center">
    <br>
    <a href="https://www.npmjs.com/package/redom"><img src="https://img.shields.io/npm/v/redom.svg?maxAge=60" alt="Version"></a>
    <a href="https://travis-ci.org/redom/redom?branch=master"><img src="https://img.shields.io/travis/redom/redom/master.svg?maxAge=60" alt="Build Status"></a>
    <a href="https://github.com/Flet/semistandard"><img src="https://img.shields.io/badge/code%20style-semistandard-brightgreen.svg?maxAge=3600" alt="JavaScript Semi-Standard Style"></a>
    <a href="https://github.com/redom/redom/blob/master/LICENSE"><img src="https://img.shields.io/npm/l/redom.svg?maxAge=60" alt="License"></a>
    <a href="#backers"><img src="https://opencollective.com/redom/backers/badge.svg" alt="Backers on Open Collective"></a>
    <a href="#sponsors"><img src="https://opencollective.com/redom/sponsors/badge.svg" alt="Sponsors on Open Collective"></a>
    <a href="https://gitter.im/pakastin/redom"><img src="https://badges.gitter.im/pakastin/redom.svg" alt="Join the chat"></a>
    <br>
    <a href="https://twitter.com/pakastin"><img src="https://img.shields.io/twitter/follow/pakastin.svg?style=social&maxAge=60" alt="Follow @pakastin"></a>
    <a href="https://twitter.com/redomjs"><img src="https://img.shields.io/twitter/follow/redomjs.svg?style=social&maxAge=60" alt="Follow @redomjs"></a>
    <br>
    <br>
</p>

**[RE:DOM](https://redom.js.org)** is a tiny **(2 KB) UI library** by [Juha Lindstedt](https://github.com/pakastin) and [contributors](https://github.com/redom/redom/graphs/contributors), which adds some useful helpers to create DOM elements and keeping them in sync with the data.

Because RE:DOM is so close to the metal and **doesn't use virtual dom**, it's actually **faster** and uses **less memory** than almost all virtual dom based libraries, including React ([benchmark](https://rawgit.com/krausest/js-framework-benchmark/master/webdriver-ts-results/table.html)).

It's also easy to create **reusable components** with RE:DOM.

Another great benefit is, that you can use just **pure JavaScript**, so no complicated templating languages to learn and hassle with.

## Supporting RE:DOM

RE:DOM is an MIT-licensed open source project with its ongoing development made possible entirely by the support of these awesome [backers](./BACKERS.md).

**If you'd like to join them, please consider:**

- [Become a backer or sponsor on Open Collective](https://opencollective.com/redom).

## Installation

```bash
# Using npm
npm install redom

# Using Yarn
yarn add redom
```

## Documentation

To check out [live examples](https://redom.js.org/#todomvc) and docs, visit [RE:DOM](https://redom.js.org/).

## Questions

For questions and support please use [community chat](https://gitter.im/pakastin/redom/).

## Tools

- [NO:DOM](https://github.com/redom/nodom) (server-side rendering)
- [Project generator](https://github.com/redom/redom-cli)
- [Dev tools for Chrome](https://github.com/redom/redom-devtools)
- [Babel RE:DOM JSX transform](https://github.com/tomerigal/babel-plugin-transform-redom-jsx)

## Performance

- [RE:DOM is one of the fastest UI libraries out there.](https://rawgit.com/krausest/js-framework-benchmark/master/webdriver-ts-results/table.html)

## Issues

Please make sure to read the [Issue Reporting Checklist](./.github/CONTRIBUTING.md#issue-reporting-guidelines) before opening an issue. Issues not conforming to the guidelines may be closed immediately.

## Changelog

Detailed changes for each release are documented in the [release notes](https://github.com/redom/redom/releases).

## Contribution

Please make sure to read the [Contributing Guide](./.github/CONTRIBUTING.md) before making a pull request.\
Thank you to all the people who already contributed to RE:DOM!

<a href="https://github.com/redom/redom/graphs/contributors">
    <img src="https://opencollective.com/redom/contributors.svg?width=890&button=false" />
</a>

## License

[MIT](http://opensource.org/licenses/MIT)

Copyright (c) 2016-present, [Juha Lindstedt](https://github.com/pakastin) and contributors
