'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

exports['default'] = createDevTools;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _instrument = require('./instrument');

var _instrument2 = _interopRequireDefault(_instrument);

function createDevTools(children) {
  var monitorElement = _react.Children.only(children);
  var monitorProps = monitorElement.props;
  var Monitor = monitorElement.type;
  var ConnectedMonitor = _reactRedux.connect(function (state) {
    return state;
  })(Monitor);
  var enhancer = _instrument2['default'](function (state, action) {
    return Monitor.reducer(state, action, monitorProps);
  });

  return (function (_Component) {
    _inherits(DevTools, _Component);

    _createClass(DevTools, null, [{
      key: 'contextTypes',
      value: {
        store: _react.PropTypes.object.isRequired
      },
      enumerable: true
    }, {
      key: 'instrument',
      value: function value() {
        return enhancer;
      },
      enumerable: true
    }]);

    function DevTools(props, context) {
      _classCallCheck(this, DevTools);

      _Component.call(this, props, context);
      this.liftedStore = context.store.liftedStore;
    }

    DevTools.prototype.render = function render() {
      return _react2['default'].createElement(ConnectedMonitor, _extends({}, monitorProps, {
        store: this.liftedStore }));
    };

    return DevTools;
  })(_react.Component);
}

module.exports = exports['default'];