'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports['default'] = createAll;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj['default'] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _reducer = require('./reducer');

var _reducer2 = _interopRequireDefault(_reducer);

var _createReduxForm = require('./createReduxForm');

var _createReduxForm2 = _interopRequireDefault(_createReduxForm);

var _createConnectReduxForm = require('./createConnectReduxForm');

var _createConnectReduxForm2 = _interopRequireDefault(_createConnectReduxForm);

var _mapValues = require('./mapValues');

var _mapValues2 = _interopRequireDefault(_mapValues);

var _bindActionData = require('./bindActionData');

var _bindActionData2 = _interopRequireDefault(_bindActionData);

var _actions = require('./actions');

var actions = _interopRequireWildcard(_actions);

var _actionTypes = require('./actionTypes');

var actionTypes = _interopRequireWildcard(_actionTypes);

// bind form as first parameter of action creators
var boundActions = _extends({}, _mapValues2['default'](_extends({}, actions, {
  initializeWithKey: function initializeWithKey(key, data) {
    return _bindActionData2['default'](actions.initialize, { key: key })(data);
  },
  destroy: function destroy(key) {
    return _bindActionData2['default'](actions.destroy, { key: key })();
  }
}), function (action) {
  return function (form) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    return _bindActionData2['default'](action, { form: form }).apply(undefined, args);
  };
}));

var blur = boundActions.blur;
var change = boundActions.change;
var destroy = boundActions.destroy;
var focus = boundActions.focus;
var initialize = boundActions.initialize;
var initializeWithKey = boundActions.initializeWithKey;
var reset = boundActions.reset;
var startAsyncValidation = boundActions.startAsyncValidation;
var startSubmit = boundActions.startSubmit;
var stopAsyncValidation = boundActions.stopAsyncValidation;
var stopSubmit = boundActions.stopSubmit;
var touch = boundActions.touch;
var untouch = boundActions.untouch;

function createAll(isReactNative, React, connect) {
  return {
    actionTypes: actionTypes,
    blur: blur,
    change: change,
    connectReduxForm: _createConnectReduxForm2['default'](isReactNative, React, connect),
    destroy: destroy,
    focus: focus,
    reducer: _reducer2['default'],
    initialize: initialize,
    initializeWithKey: initializeWithKey,
    reduxForm: _createReduxForm2['default'](isReactNative, React),
    reset: reset,
    startAsyncValidation: startAsyncValidation,
    startSubmit: startSubmit,
    stopAsyncValidation: stopAsyncValidation,
    stopSubmit: stopSubmit,
    touch: touch,
    untouch: untouch
  };
}

module.exports = exports['default'];