'use strict';

exports.__esModule = true;
exports['default'] = createConnectReduxForm;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _createReduxForm = require('./createReduxForm');

var _createReduxForm2 = _interopRequireDefault(_createReduxForm);

function reduceDecorators() {
  for (var _len = arguments.length, decorators = Array(_len), _key = 0; _key < _len; _key++) {
    decorators[_key] = arguments[_key];
  }

  return function (DecoratedComponent) {
    return decorators.reduce(function (accumulator, decorator) {
      return decorator(accumulator);
    }, DecoratedComponent);
  };
}

function createConnectReduxForm(isReactNative, React, connect) {
  var reduxForm = _createReduxForm2['default'](isReactNative, React);
  var connector = connect(function (state) {
    return {
      form: state.form
    };
  });
  return function connectReduxForm() {
    return reduceDecorators(reduxForm.apply(undefined, arguments), connector);
  };
}

module.exports = exports['default'];