'use strict';

exports.__esModule = true;

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports['default'] = createReduxForm;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj['default'] = obj; return newObj; } }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _actions = require('./actions');

var formActions = _interopRequireWildcard(_actions);

var _getDisplayName = require('./getDisplayName');

var _getDisplayName2 = _interopRequireDefault(_getDisplayName);

var _isPristine = require('./isPristine');

var _isPristine2 = _interopRequireDefault(_isPristine);

var _isValid = require('./isValid');

var _isValid2 = _interopRequireDefault(_isValid);

var _bindActionData = require('./bindActionData');

var _bindActionData2 = _interopRequireDefault(_bindActionData);

var _reducer = require('./reducer');

var _reactLazyCache = require('react-lazy-cache');

var _reactLazyCache2 = _interopRequireDefault(_reactLazyCache);

function isReadonly(prop) {
  var writeProps = ['asyncValidate', 'handleBlur', 'handleChange', 'handleFocus', 'handleSubmit', 'onBlur', 'onChange', 'onFocus'];
  return ! ~writeProps.indexOf(prop);
}

function silenceEvents(fn) {
  return function (event) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    if (event && event.preventDefault) {
      event.preventDefault();
      return fn.apply(undefined, args);
    }
    return fn.apply(undefined, [event].concat(args));
  };
}

function hasErrors(errors) {
  if (!errors) {
    return false;
  }

  var errorsKeys = Object.keys(errors);
  var errorCount = errorsKeys.length;

  if (errorCount < 1) {
    return false;
  }

  return errorsKeys.reduce(function (valid, error) {
    return valid && _isValid2['default'](errors[error]);
  }, true);
}

function createReduxForm(isReactNative, React) {
  var Component = React.Component;
  var PropTypes = React.PropTypes;

  function getValue(passedValue, event) {
    if (passedValue !== undefined || !event) {
      // extract value from { value: value } structure. https://github.com/nikgraf/belle/issues/58
      return typeof passedValue === 'object' && passedValue.value ? passedValue.value : passedValue;
    }
    if (!isReactNative && event.nativeEvent !== undefined && event.nativeEvent.text !== undefined) {
      return event.nativeEvent.text;
    }
    if (isReactNative && event.nativeEvent !== undefined) {
      return event.nativeEvent.text;
    }
    if (event.target === undefined) {
      // is it a value instead of an event?
      return event;
    }
    var _event$target = event.target;
    var type = _event$target.type;
    var value = _event$target.value;
    var checked = _event$target.checked;
    var files = _event$target.files;
    var dataTransfer = event.dataTransfer;

    if (type === 'checkbox') {
      return checked;
    }
    if (type === 'file') {
      return files || dataTransfer && dataTransfer.files;
    }
    return value;
  }

  return function reduxForm(config) {
    var _extends7 = _extends({
      validate: function validate() {
        return {};
      },
      touchOnBlur: true,
      touchOnChange: false,
      readonly: false,
      asyncValidate: null,
      asyncBlurFields: []
    }, config);

    var formName = _extends7.form;
    var fields = _extends7.fields;
    var syncValidate = _extends7.validate;
    var readonly = _extends7.readonly;
    var touchOnBlur = _extends7.touchOnBlur;
    var touchOnChange = _extends7.touchOnChange;
    var asyncValidate = _extends7.asyncValidate;
    var asyncBlurFields = _extends7.asyncBlurFields;

    if (!fields || !fields.length) {
      throw new Error('No fields passed to redux-form. Must be passed to ' + 'connectReduxForm({fields: ["my", "field", "names"]})');
    }

    var filterProps = function filterProps(props) {
      return readonly ? Object.keys(props).reduce(function (accumulator, prop) {
        var _extends2;

        return isReadonly(prop) ? _extends({}, accumulator, (_extends2 = {}, _extends2[prop] = props[prop], _extends2)) : accumulator;
      }, {}) : props;
    };

    return function (DecoratedComponent) {
      return (function (_Component) {
        _inherits(ReduxForm, _Component);

        _createClass(ReduxForm, null, [{
          key: 'displayName',
          value: 'ReduxForm(' + _getDisplayName2['default'](DecoratedComponent) + ')',
          enumerable: true
        }, {
          key: 'DecoratedComponent',
          value: DecoratedComponent,
          enumerable: true
        }, {
          key: 'propTypes',
          value: {
            formName: PropTypes.string,
            formKey: PropTypes.string,
            form: PropTypes.object,
            onSubmit: PropTypes.func,
            dispatch: PropTypes.func.isRequired,
            initialValues: PropTypes.object
          },
          enumerable: true
        }, {
          key: 'defaultProps',
          value: {
            formName: formName
          },
          enumerable: true
        }]);

        function ReduxForm(props) {
          var _this = this;

          _classCallCheck(this, ReduxForm);

          _Component.call(this, props);
          this.cache = _reactLazyCache2['default'](this, {
            _actions: {
              params: ['formName', 'formKey'],
              fn: function fn(formName, formKey) {
                return (// eslint-disable-line no-shadow
                  formKey ? _bindActionData2['default'](formActions, { form: formName, key: formKey }) : _bindActionData2['default'](formActions, { form: formName })
                );
              }
            },

            _handleBlur: {
              params: ['_actions', 'dispatch'],
              fn: function fn(actions, dispatch) {
                return function (name, value) {
                  return function (event) {
                    var fieldValue = getValue(value, event);
                    var doBlur = _bindActionData2['default'](actions.blur, { touch: touchOnBlur });
                    dispatch(doBlur(name, fieldValue));
                    if (asyncValidate && ~asyncBlurFields.indexOf(name)) {
                      var _extends3;

                      var values = _this.getValues();
                      var syncError = _this.runSyncValidation(_extends({}, values, (_extends3 = {}, _extends3[name] = fieldValue, _extends3)))[name];
                      // only dispatch async call if all synchronous client-side validation passes for this field
                      if (!syncError) {
                        _this.runAsyncValidation(actions, values);
                      }
                    }
                  };
                };
              }
            },
            _handleFocus: {
              params: ['_actions', 'dispatch'],
              fn: function fn(actions, dispatch) {
                return function (name) {
                  return function () {
                    return dispatch(actions.focus(name));
                  };
                };
              }
            },
            _handleChange: {
              params: ['_actions', 'dispatch'],
              fn: function fn(actions, dispatch) {
                return function (name, value) {
                  var doChange = _bindActionData2['default'](actions.change, { touch: touchOnChange });

                  return value ? dispatch(doChange(name, getValue(value))) : function (event) {
                    return dispatch(doChange(name, getValue(value, event)));
                  };
                };
              }
            },
            _fieldActions: {
              params: ['_handleBlur', '_handleChange', '_handleFocus'],
              fn: function fn(handleBlur, handleChange, handleFocus) {
                return fields.reduce(function (accumulator, name) {
                  var _extends4;

                  var fieldBlur = handleBlur(name);
                  var fieldChange = handleChange(name);
                  var fieldFocus = handleFocus(name);
                  return _extends({}, accumulator, (_extends4 = {}, _extends4[name] = filterProps({
                    handleBlur: fieldBlur,
                    handleChange: fieldChange,
                    handleFocus: fieldFocus,
                    name: name,
                    onBlur: fieldBlur,
                    onChange: fieldChange,
                    onDrop: function onDrop(event) {
                      fieldChange(event.dataTransfer.getData('value'));
                    },
                    onFocus: fieldFocus,
                    onUpdate: fieldChange // alias to support belle. https://github.com/nikgraf/belle/issues/58
                  }), _extends4));
                }, {});
              }
            }
          });
        }

        ReduxForm.prototype.componentWillMount = function componentWillMount() {
          var _props = this.props;
          var initialValues = _props.initialValues;
          var dispatch = _props.dispatch;
          // eslint-disable-line no-shadow
          if (initialValues) {
            var initialize = this.cache._actions.initialize;

            dispatch(initialize(initialValues));
          }
        };

        ReduxForm.prototype.runSyncValidation = function runSyncValidation(values) {
          return syncValidate(values, this.props);
        };

        ReduxForm.prototype.runAsyncValidation = function runAsyncValidation(actions, values) {
          var _props2 = this.props;
          var dispatch = _props2.dispatch;
          var formKey = _props2.formKey;
          // eslint-disable-line no-shadow
          dispatch(actions.startAsyncValidation(formKey));
          var promise = asyncValidate(values, dispatch);
          if (!promise || typeof promise.then !== 'function') {
            throw new Error('asyncValidate function passed to reduxForm must return a promise!');
          }
          var handleErrors = function handleErrors(asyncErrors) {
            dispatch(actions.stopAsyncValidation(asyncErrors));
            return hasErrors(asyncErrors);
          };
          return promise.then(handleErrors, handleErrors);
        };

        ReduxForm.prototype.getSubForm = function getSubForm() {
          var _props3 = this.props;
          var formName = _props3.formName;
          var form = _props3.form;
          var formKey = _props3.formKey;
          // eslint-disable-line no-shadow
          if (form && form[formName]) {
            if (formKey) {
              if (form[formName][formKey]) {
                return form[formName][formKey];
              }
            } else {
              return form[formName];
            }
          }
          return _reducer.initialState;
        };

        ReduxForm.prototype.getValues = function getValues() {
          var subForm = this.getSubForm();
          return fields.reduce(function (accumulator, field) {
            var _extends5;

            return _extends({}, accumulator, (_extends5 = {}, _extends5[field] = subForm[field] ? subForm[field].value : undefined, _extends5));
          }, {});
        };

        ReduxForm.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
          this.cache.componentWillReceiveProps(nextProps);
        };

        ReduxForm.prototype.render = function render() {
          var _this2 = this;

          // Read props
          var _props4 = this.props;
          var formName = _props4.formName;
          var form = _props4.form;
          var formKey = _props4.formKey;
          var dispatch = _props4.dispatch;

          var passableProps = _objectWithoutProperties(_props4, ['formName', 'form', 'formKey', 'dispatch']);

          // eslint-disable-line no-shadow
          if (!formName) {
            throw new Error('No form name given to redux-form. Must be passed to ' + 'connectReduxForm({form: [form name]}) or as a "formName" prop');
          }
          var _cache = this.cache;
          var actions = _cache._actions;
          var fieldActions = _cache._fieldActions;
          var handleBlur = _cache._handleBlur;
          var handleChange = _cache._handleChange;
          var handleFocus = _cache._handleFocus;

          var subForm = this.getSubForm();

          // Calculate calculable state
          var allValid = true;
          var allPristine = true;

          var handleSubmit = function handleSubmit(submitOrEvent) {
            var createEventHandler = function createEventHandler(submit) {
              return function (event) {
                if (event && event.preventDefault) {
                  event.preventDefault();
                  event.stopPropagation();
                }
                var values = _this2.getValues();
                var syncErrors = _this2.runSyncValidation(values);
                if (!hasErrors(syncErrors)) {
                  var _ret = (function () {
                    var submitWithPromiseCheck = function submitWithPromiseCheck() {
                      var result = submit(values);
                      if (result && typeof result.then === 'function') {
                        // you're showing real promise, kid!
                        dispatch(actions.startSubmit());
                        return result.then(function (submitResult) {
                          dispatch(actions.stopSubmit());
                          return submitResult;
                        }, function (submitError) {
                          dispatch(actions.stopSubmit(submitError));
                          return submitError;
                        });
                      }
                    };
                    dispatch(actions.touch.apply(actions, fields));
                    if (allValid) {
                      if (asyncValidate) {
                        return {
                          v: _this2.runAsyncValidation(actions, values).then(function (asyncValid) {
                            if (allValid && asyncValid) {
                              return submitWithPromiseCheck(values);
                            }
                          })
                        };
                      }
                      return {
                        v: submitWithPromiseCheck(values)
                      };
                    }
                  })();

                  if (typeof _ret === 'object') return _ret.v;
                }
              };
            };
            if (typeof submitOrEvent === 'function') {
              return createEventHandler(submitOrEvent);
            }
            var onSubmit = _this2.props.onSubmit;

            if (!onSubmit) {
              throw new Error('You must either pass handleSubmit() an onSubmit function or pass onSubmit as a prop');
            }
            createEventHandler(onSubmit)(submitOrEvent /* is event */);
          };

          // Define fields
          var values = this.getValues();
          var syncErrors = this.runSyncValidation(values);
          var allFields = fields.reduce(function (accumulator, name) {
            var _extends6;

            var field = subForm[name] || {};
            var pristine = _isPristine2['default'](field.value, field.initial);
            var error = syncErrors[name] || field.asyncError || field.submitError;
            var valid = _isValid2['default'](error);
            var initialValue = passableProps.initialValues && passableProps.initialValues[name];
            if (!valid) {
              allValid = false;
            }
            if (!pristine) {
              allPristine = false;
            }
            return _extends({}, accumulator, (_extends6 = {}, _extends6[name] = filterProps(_extends({
              active: subForm._active === name,
              checked: typeof field.value === 'boolean' ? field.value : undefined,
              defaultChecked: initialValue,
              defaultValue: initialValue,
              dirty: !pristine,
              error: error
            }, fieldActions[name], {
              invalid: !valid,
              name: name,
              onDrag: function onDrag(event) {
                return event.dataTransfer.setData('value', field.value);
              },
              pristine: pristine,
              touched: field.touched,
              valid: valid,
              value: field.value,
              visited: field.visited
            })), _extends6));
          }, {});
          var formError = syncErrors._error || subForm._error;
          if (formError) {
            allValid = false;
          }

          // Return decorated component
          return React.createElement(DecoratedComponent, _extends({
            // State:
            active: subForm._active,
            asyncValidating: subForm._asyncValidating,
            dirty: !allPristine,
            error: formError,
            fields: allFields,
            formKey: formKey,
            invalid: !allValid,
            pristine: allPristine,
            submitting: subForm._submitting,
            valid: allValid,
            values: values,

            // Actions:
            asyncValidate: silenceEvents(function () {
              return _this2.runAsyncValidation(actions, values);
            }),
            destroyForm: silenceEvents(function () {
              return dispatch(actions.destroy());
            }),
            handleBlur: silenceEvents(handleBlur),
            handleChange: silenceEvents(handleChange),
            handleFocus: handleFocus,
            handleSubmit: silenceEvents(handleSubmit),
            initializeForm: silenceEvents(function (initialValues) {
              return dispatch(actions.initialize(initialValues));
            }),
            resetForm: silenceEvents(function () {
              return dispatch(actions.reset());
            }),
            touch: silenceEvents(function () {
              return dispatch(actions.touch.apply(actions, arguments));
            }),
            touchAll: silenceEvents(function () {
              return dispatch(actions.touch.apply(actions, fields));
            }),
            untouch: silenceEvents(function () {
              return dispatch(actions.untouch.apply(actions, arguments));
            }),
            untouchAll: silenceEvents(function () {
              return dispatch(actions.untouch.apply(actions, fields));
            }),

            // Other:
            dispatch: dispatch
          }, passableProps));
        };

        return ReduxForm;
      })(Component);
    };
  };
}

module.exports = exports['default'];