'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var _actionTypes = require('./actionTypes');

var _mapValues = require('./mapValues');

var _mapValues2 = _interopRequireDefault(_mapValues);

var initialState = {
  _active: undefined,
  _asyncValidating: false,
  _error: undefined,
  _submitting: false
};

exports.initialState = initialState;
var getValues = function getValues(state) {
  return Object.keys(state).reduce(function (accumulator, name) {
    var _extends2;

    return name[0] === '_' ? accumulator : _extends({}, accumulator, (_extends2 = {}, _extends2[name] = state[name].value, _extends2));
  }, {});
};

var reducer = function reducer() {
  var state = arguments.length <= 0 || arguments[0] === undefined ? initialState : arguments[0];

  var _extends3, _extends4, _extends5;

  var action = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

  switch (action.type) {
    case _actionTypes.BLUR:
      return _extends({}, state, (_extends3 = {}, _extends3[action.field] = _extends({}, state[action.field], {
        value: action.value === undefined ? (state[action.field] || {}).value : action.value,
        touched: !!(action.touch || (state[action.field] || {}).touched)
      }), _extends3._active = undefined, _extends3));
    case _actionTypes.CHANGE:
      return _extends({}, state, (_extends4 = {}, _extends4[action.field] = _extends({}, state[action.field], {
        value: action.value,
        touched: !!(action.touch || (state[action.field] || {}).touched),
        asyncError: null,
        submitError: null
      }), _extends4._error = undefined, _extends4));
    case _actionTypes.DESTROY:
      return undefined;
    case _actionTypes.FOCUS:
      return _extends({}, state, (_extends5 = {}, _extends5[action.field] = _extends({}, state[action.field], {
        visited: true
      }), _extends5._active = action.field, _extends5));
    case _actionTypes.INITIALIZE:
      return _extends({}, _mapValues2['default'](action.data, function (value) {
        return {
          initial: value,
          value: value
        };
      }), {
        _asyncValidating: false,
        _active: undefined,
        _error: undefined,
        _submitting: false
      });
    case _actionTypes.RESET:
      return _extends({}, _mapValues2['default'](state, function (field, name) {
        return name[0] === '_' ? field : {
          initial: field.initial,
          value: field.initial
        };
      }), {
        _active: undefined,
        _asyncValidating: false,
        _error: undefined,
        _submitting: false
      });
    case _actionTypes.START_ASYNC_VALIDATION:
      return _extends({}, state, {
        _asyncValidating: true
      });
    case _actionTypes.START_SUBMIT:
      return _extends({}, state, {
        _submitting: true
      });
    case _actionTypes.STOP_ASYNC_VALIDATION:
      return _extends({}, state, _mapValues2['default'](action.errors, function (error, key) {
        return _extends({}, state[key], {
          asyncError: error
        });
      }), {
        _asyncValidating: false,
        _error: action.errors._error
      });
    case _actionTypes.STOP_SUBMIT:
      return _extends({}, state, action.errors ? _mapValues2['default'](action.errors, function (error, key) {
        return _extends({}, state[key], {
          submitError: error
        });
      }) : {}, {
        _error: action.errors && action.errors._error,
        _submitting: false
      });
    case _actionTypes.TOUCH:
      return _extends({}, state, action.fields.reduce(function (accumulator, field) {
        var _extends6;

        return _extends({}, accumulator, (_extends6 = {}, _extends6[field] = _extends({}, state[field], {
          touched: true
        }), _extends6));
      }, {}));
    case _actionTypes.UNTOUCH:
      return _extends({}, state, action.fields.reduce(function (accumulator, field) {
        var _extends7;

        return _extends({}, accumulator, (_extends7 = {}, _extends7[field] = _extends({}, state[field], {
          touched: false
        }), _extends7));
      }, {}));
    default:
      return state;
  }
};

function formReducer() {
  var state = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

  var _extends13;

  var action = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
  var form = action.form;
  var key = action.key;

  var rest = _objectWithoutProperties(action, ['form', 'key']);

  if (!form) {
    return state;
  }
  if (key) {
    var _extends10, _extends11;

    if (action.type === _actionTypes.DESTROY) {
      var _extends9;

      return _extends({}, state, (_extends9 = {}, _extends9[form] = Object.keys(state[form]).reduce(function (accumulator, stateKey) {
        var _extends8;

        return stateKey === key ? accumulator : _extends({}, accumulator, (_extends8 = {}, _extends8[stateKey] = state[form][stateKey], _extends8));
      }, {}), _extends9));
    }
    return _extends({}, state, (_extends11 = {}, _extends11[form] = _extends({}, state[form], (_extends10 = {}, _extends10[key] = reducer((state[form] || {})[key], rest), _extends10)), _extends11));
  }
  if (action.type === _actionTypes.DESTROY) {
    return Object.keys(state).reduce(function (accumulator, formName) {
      var _extends12;

      return formName === form ? accumulator : _extends({}, accumulator, (_extends12 = {}, _extends12[formName] = state[formName], _extends12));
    }, {});
  }
  return _extends({}, state, (_extends13 = {}, _extends13[form] = reducer(state[form], rest), _extends13));
}

/**
 * Adds additional functionality to the reducer
 */
function decorate(target) {
  target.plugin = function plugin(reducers) {
    var _this = this;

    return decorate(function () {
      var state = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];
      var action = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var result = _this(state, action);
      return _extends({}, result, _mapValues2['default'](reducers, function (red, key) {
        return red(result[key] || initialState, action);
      }));
    });
  };

  target.normalize = function normalize(normalizers) {
    var _this2 = this;

    return decorate(function () {
      var state = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];
      var action = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var result = _this2(state, action);
      return _extends({}, result, _mapValues2['default'](normalizers, function (formNormalizers, form) {
        var formResult = _extends({}, initialState, result[form]);
        return _extends({}, formResult, _mapValues2['default'](formNormalizers, function (fieldNormalizer, field) {
          return _extends({}, formResult[field], {
            value: fieldNormalizer(formResult[field] ? formResult[field].value : undefined, // value
            state[form] && state[form][field] ? state[form][field].value : undefined, // previous value
            getValues(formResult)) // all field values
          });
        }));
      }));
    });
  };

  return target;
}

exports['default'] = decorate(formReducer);