var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import { Component, PropTypes, createElement } from 'react';
import { connect } from 'react-redux';
import createFieldProps from './createFieldProps';
import plain from './structure/plain';

var propsToNotUpdateFor = ['_reduxForm'];

var createConnectedField = function createConnectedField(_ref) {
  var deepEqual = _ref.deepEqual;
  var getIn = _ref.getIn;


  var getSyncError = function getSyncError(syncErrors, name) {
    var error = plain.getIn(syncErrors, name);
    // Because the error for this field might not be at a level in the error structure where
    // it can be set directly, it might need to be unwrapped from the _error property
    return error && error._error ? error._error : error;
  };

  var ConnectedField = function (_Component) {
    _inherits(ConnectedField, _Component);

    function ConnectedField() {
      _classCallCheck(this, ConnectedField);

      return _possibleConstructorReturn(this, (ConnectedField.__proto__ || Object.getPrototypeOf(ConnectedField)).apply(this, arguments));
    }

    _createClass(ConnectedField, [{
      key: 'shouldComponentUpdate',
      value: function shouldComponentUpdate(nextProps) {
        var _this2 = this;

        var nextPropsKeys = Object.keys(nextProps);
        var thisPropsKeys = Object.keys(this.props);
        return nextPropsKeys.length == thisPropsKeys.length && nextPropsKeys.some(function (prop) {
          return !~propsToNotUpdateFor.indexOf(prop) && !deepEqual(_this2.props[prop], nextProps[prop]);
        });
      }
    }, {
      key: 'isPristine',
      value: function isPristine() {
        return this.props.pristine;
      }
    }, {
      key: 'getValue',
      value: function getValue() {
        return this.props.value;
      }
    }, {
      key: 'getRenderedComponent',
      value: function getRenderedComponent() {
        return this.refs.renderedComponent;
      }
    }, {
      key: 'render',
      value: function render() {
        var _props = this.props;
        var component = _props.component;
        var withRef = _props.withRef;
        var name = _props.name;
        var _reduxForm = _props._reduxForm;

        var rest = _objectWithoutProperties(_props, ['component', 'withRef', 'name', '_reduxForm']);

        var asyncValidate = _reduxForm.asyncValidate;
        var blur = _reduxForm.blur;
        var change = _reduxForm.change;
        var focus = _reduxForm.focus;

        var _createFieldProps = createFieldProps(getIn, name, _extends({}, rest, {
          name: name,
          blur: blur,
          change: change,
          focus: focus
        }), asyncValidate);

        var custom = _createFieldProps.custom;

        var props = _objectWithoutProperties(_createFieldProps, ['custom']);

        if (withRef) {
          props.ref = 'renderedComponent';
        }
        if (typeof component === 'string') {
          var input = props.input;
          var meta = props.meta; // eslint-disable-line no-unused-vars
          // flatten input into other props

          return createElement(component, _extends({}, input, custom));
        } else {
          return createElement(component, _extends({}, props, custom));
        }
      }
    }]);

    return ConnectedField;
  }(Component);

  ConnectedField.propTypes = {
    component: PropTypes.oneOfType([PropTypes.func, PropTypes.string]).isRequired,
    props: PropTypes.object
  };

  var connector = connect(function (state, ownProps) {
    var name = ownProps.name;
    var _ownProps$_reduxForm = ownProps._reduxForm;
    var initialValues = _ownProps$_reduxForm.initialValues;
    var getFormState = _ownProps$_reduxForm.getFormState;

    var formState = getFormState(state);
    var initialState = getIn(formState, 'initial.' + name);
    var initial = initialState !== undefined ? initialState : initialValues && getIn(initialValues, name);
    var value = getIn(formState, 'values.' + name);
    var submitting = getIn(formState, 'submitting');
    var syncError = getSyncError(getIn(formState, 'syncErrors'), name);
    var pristine = value === initial;
    return {
      asyncError: getIn(formState, 'asyncErrors.' + name),
      asyncValidating: getIn(formState, 'asyncValidating') === name,
      dirty: !pristine,
      pristine: pristine,
      state: getIn(formState, 'fields.' + name),
      submitError: getIn(formState, 'submitErrors.' + name),
      submitting: submitting,
      syncError: syncError,
      value: value,
      _value: ownProps.value // save value passed in (for checkboxes)
    };
  }, undefined, undefined, { withRef: true });
  return connector(ConnectedField);
};

export default createConnectedField;