'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
var createIsPristine = function createIsPristine(_ref) {
  var deepEqual = _ref.deepEqual;
  var empty = _ref.empty;
  var getIn = _ref.getIn;
  return function (form) {
    var getFormState = arguments.length <= 1 || arguments[1] === undefined ? function (state) {
      return getIn(state, 'form');
    } : arguments[1];
    return function (state) {
      var formState = getFormState(state);
      var initial = getIn(formState, form + '.initial') || empty;
      var values = getIn(formState, form + '.values') || initial;
      return deepEqual(initial, values);
    };
  };
};

exports.default = createIsPristine;