# redux-form
---
[<img src="http://npm.packagequality.com/badge/redux-form.png" align="right"/>](http://packagequality.com/#?package=redux-form)

[![NPM Version](https://img.shields.io/npm/v/redux-form.svg?style=flat)](https://www.npmjs.com/package/redux-form) 
[![NPM Downloads](https://img.shields.io/npm/dm/redux-form.svg?style=flat)](https://www.npmjs.com/package/redux-form)
[![Build Status](https://img.shields.io/travis/erikras/redux-form/v6.svg?style=flat)](https://travis-ci.org/erikras/redux-form)
[![codecov.io](https://codecov.io/gh/erikras/redux-form/branch/master/graph/badge.svg)](https://codecov.io/gh/erikras/redux-form)
[![Code Climate](https://codeclimate.com/github/erikras/redux-form/badges/gpa.svg)](https://codeclimate.com/github/erikras/redux-form)
[![PayPal donate button](http://img.shields.io/paypal/donate.png?color=yellowgreen)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=3QQPTMLGV6GU2)
[![Twitter URL](https://img.shields.io/twitter/url/https/github.com/erikras/redux-form.svg?style=social)](https://twitter.com/intent/tweet?text=With%20@ReduxForm,%20I%20can%20keep%20all%20my%20form%20state%20in%20Redux!%20Thanks,%20@erikras!)
[![Patreon](https://img.shields.io/badge/patreon-support%20the%20author-blue.svg)](https://www.patreon.com/erikras)

`redux-form` works with [React Redux](https://github.com/rackt/react-redux) to enable an html form in
[React](https://github.com/facebook/react) to use [Redux](https://github.com/rackt/redux) to store all of its state.
[![Beerpay](https://beerpay.io/erikras/redux-form/badge.svg)](https://beerpay.io/erikras/redux-form)

[<img src="logo.png" align="right" class="logo" height="151" width="250"/>](http://erikras.github.io/redux-form/)

## Installation
```npm install --save redux-form```

## Documentation

* [Getting Started](https://redux-form.com/6.6.3/docs/GettingStarted.md/)
* [Examples](https://redux-form.com/6.6.3/examples/)
* [API](https://redux-form.com/6.6.3/docs/api/)
* [FAQ](https://redux-form.com/6.6.3/docs/faq/)
* [Release Notes](https://github.com/erikras/redux-form/releases)
* [Older Documentation](https://redux-form.com/6.6.3/docs/DocumentationVersions.md/)

## Code Sandboxes

You can play around with `redux-form` in these sandbox versions of the Examples.

* [Simple Form](https://codesandbox.io/s/mZRjw05yp)
* [Synchronous Validation](https://codesandbox.io/s/pQj03w7Y6)
* [Field-Level Validation](https://codesandbox.io/s/PNQYw1kVy)
* [Submit Validation](https://codesandbox.io/s/XoA5vXDgA)
* [Asynchronous Blur Validation](https://codesandbox.io/s/nKlYo387)
* [Initializing From State](https://codesandbox.io/s/MQnD536Km)
* [Field Arrays](https://codesandbox.io/s/Ww4QG1Wx)
* [Remote Submit](https://codesandbox.io/s/ElYvJR21K)
* [Normalizing](https://codesandbox.io/s/L8KWERjDw)
* [Immutable JS](https://codesandbox.io/s/ZVGJQBJMw)
* [Selecting Form Values](https://codesandbox.io/s/gJOBWZMRZ)
* [Wizard Form](https://codesandbox.io/s/0Qzz3843)

## Videos

- [Abstracting Form State with Redux Form at JS Channel - Bengaluru 2016](https://youtu.be/eDTi7lYR1VU)
[![Abstracting Form State with Redux Form at JS Channel - Bengaluru 2016](docs/video-thumb.jpg)](https://youtu.be/eDTi7lYR1VU)
