var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

import { ARRAY_INSERT, ARRAY_MOVE, ARRAY_POP, ARRAY_PUSH, ARRAY_REMOVE, ARRAY_REMOVE_ALL, ARRAY_SHIFT, ARRAY_SPLICE, ARRAY_SWAP, ARRAY_UNSHIFT, AUTOFILL, BLUR, CHANGE, CLEAR_SUBMIT, CLEAR_SUBMIT_ERRORS, CLEAR_ASYNC_ERROR, DESTROY, FOCUS, INITIALIZE, REGISTER_FIELD, RESET, SET_SUBMIT_FAILED, SET_SUBMIT_SUCCEEDED, START_ASYNC_VALIDATION, START_SUBMIT, STOP_ASYNC_VALIDATION, STOP_SUBMIT, SUBMIT, TOUCH, UNREGISTER_FIELD, UNTOUCH, UPDATE_SYNC_ERRORS, UPDATE_SYNC_WARNINGS } from './actionTypes';

export var arrayInsert = function arrayInsert(form, field, index, value) {
  return {
    type: ARRAY_INSERT,
    meta: { form: form, field: field, index: index },
    payload: value
  };
};

export var arrayMove = function arrayMove(form, field, from, to) {
  return {
    type: ARRAY_MOVE,
    meta: { form: form, field: field, from: from, to: to }
  };
};

export var arrayPop = function arrayPop(form, field) {
  return {
    type: ARRAY_POP,
    meta: { form: form, field: field }
  };
};

export var arrayPush = function arrayPush(form, field, value) {
  return {
    type: ARRAY_PUSH,
    meta: { form: form, field: field },
    payload: value
  };
};

export var arrayRemove = function arrayRemove(form, field, index) {
  return {
    type: ARRAY_REMOVE,
    meta: { form: form, field: field, index: index }
  };
};

export var arrayRemoveAll = function arrayRemoveAll(form, field) {
  return {
    type: ARRAY_REMOVE_ALL,
    meta: { form: form, field: field }
  };
};

export var arrayShift = function arrayShift(form, field) {
  return {
    type: ARRAY_SHIFT,
    meta: { form: form, field: field }
  };
};

export var arraySplice = function arraySplice(form, field, index, removeNum, value) {
  var action = {
    type: ARRAY_SPLICE,
    meta: { form: form, field: field, index: index, removeNum: removeNum }
  };
  if (value !== undefined) {
    action.payload = value;
  }
  return action;
};

export var arraySwap = function arraySwap(form, field, indexA, indexB) {
  if (indexA === indexB) {
    throw new Error('Swap indices cannot be equal');
  }
  if (indexA < 0 || indexB < 0) {
    throw new Error('Swap indices cannot be negative');
  }
  return { type: ARRAY_SWAP, meta: { form: form, field: field, indexA: indexA, indexB: indexB } };
};

export var arrayUnshift = function arrayUnshift(form, field, value) {
  return {
    type: ARRAY_UNSHIFT,
    meta: { form: form, field: field },
    payload: value
  };
};

export var autofill = function autofill(form, field, value) {
  return {
    type: AUTOFILL,
    meta: { form: form, field: field },
    payload: value
  };
};

export var blur = function blur(form, field, value, touch) {
  return {
    type: BLUR,
    meta: { form: form, field: field, touch: touch },
    payload: value
  };
};

export var change = function change(form, field, value, touch, persistentSubmitErrors) {
  return {
    type: CHANGE,
    meta: { form: form, field: field, touch: touch, persistentSubmitErrors: persistentSubmitErrors },
    payload: value
  };
};

export var clearSubmit = function clearSubmit(form) {
  return { type: CLEAR_SUBMIT, meta: { form: form } };
};

export var clearSubmitErrors = function clearSubmitErrors(form) {
  return {
    type: CLEAR_SUBMIT_ERRORS,
    meta: { form: form }
  };
};

export var clearAsyncError = function clearAsyncError(form, field) {
  return {
    type: CLEAR_ASYNC_ERROR,
    meta: { form: form, field: field }
  };
};

export var destroy = function destroy() {
  for (var _len = arguments.length, form = Array(_len), _key = 0; _key < _len; _key++) {
    form[_key] = arguments[_key];
  }

  return { type: DESTROY, meta: { form: form } };
};

export var focus = function focus(form, field) {
  return { type: FOCUS, meta: { form: form, field: field } };
};

export var initialize = function initialize(form, values, keepDirty) {
  var otherMeta = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

  if (keepDirty instanceof Object) {
    otherMeta = keepDirty;
    keepDirty = false;
  }
  return {
    type: INITIALIZE,
    meta: _extends({ form: form, keepDirty: keepDirty }, otherMeta),
    payload: values
  };
};

export var registerField = function registerField(form, name, type) {
  return {
    type: REGISTER_FIELD,
    meta: { form: form },
    payload: { name: name, type: type }
  };
};

export var reset = function reset(form) {
  return { type: RESET, meta: { form: form } };
};

export var startAsyncValidation = function startAsyncValidation(form, field) {
  return {
    type: START_ASYNC_VALIDATION,
    meta: { form: form, field: field }
  };
};

export var startSubmit = function startSubmit(form) {
  return { type: START_SUBMIT, meta: { form: form } };
};

export var stopAsyncValidation = function stopAsyncValidation(form, errors) {
  var action = {
    type: STOP_ASYNC_VALIDATION,
    meta: { form: form },
    payload: errors
  };
  if (errors && Object.keys(errors).length) {
    action.error = true;
  }
  return action;
};

export var stopSubmit = function stopSubmit(form, errors) {
  var action = {
    type: STOP_SUBMIT,
    meta: { form: form },
    payload: errors
  };
  if (errors && Object.keys(errors).length) {
    action.error = true;
  }
  return action;
};

export var submit = function submit(form) {
  return { type: SUBMIT, meta: { form: form } };
};

export var setSubmitFailed = function setSubmitFailed(form) {
  for (var _len2 = arguments.length, fields = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    fields[_key2 - 1] = arguments[_key2];
  }

  return {
    type: SET_SUBMIT_FAILED,
    meta: { form: form, fields: fields },
    error: true
  };
};

export var setSubmitSucceeded = function setSubmitSucceeded(form) {
  for (var _len3 = arguments.length, fields = Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
    fields[_key3 - 1] = arguments[_key3];
  }

  return {
    type: SET_SUBMIT_SUCCEEDED,
    meta: { form: form, fields: fields },
    error: false
  };
};

export var touch = function touch(form) {
  for (var _len4 = arguments.length, fields = Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
    fields[_key4 - 1] = arguments[_key4];
  }

  return {
    type: TOUCH,
    meta: { form: form, fields: fields }
  };
};

export var unregisterField = function unregisterField(form, name) {
  var destroyOnUnmount = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  return {
    type: UNREGISTER_FIELD,
    meta: { form: form },
    payload: { name: name, destroyOnUnmount: destroyOnUnmount }
  };
};

export var untouch = function untouch(form) {
  for (var _len5 = arguments.length, fields = Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
    fields[_key5 - 1] = arguments[_key5];
  }

  return {
    type: UNTOUCH,
    meta: { form: form, fields: fields }
  };
};

export var updateSyncErrors = function updateSyncErrors(form) {
  var syncErrors = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var error = arguments[2];
  return {
    type: UPDATE_SYNC_ERRORS,
    meta: { form: form },
    payload: { syncErrors: syncErrors, error: error }
  };
};

export var updateSyncWarnings = function updateSyncWarnings(form) {
  var syncWarnings = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var warning = arguments[2];
  return {
    type: UPDATE_SYNC_WARNINGS,
    meta: { form: form },
    payload: { syncWarnings: syncWarnings, warning: warning }
  };
};