'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _expect = require('expect');

var _reactRedux = require('react-redux');

var _redux = require('redux');

var _reduxImmutablejs = require('redux-immutablejs');

var _testUtils = require('react-dom/test-utils');

var _testUtils2 = _interopRequireDefault(_testUtils);

var _createReduxForm = require('../createReduxForm');

var _createReduxForm2 = _interopRequireDefault(_createReduxForm);

var _createReducer = require('../createReducer');

var _createReducer2 = _interopRequireDefault(_createReducer);

var _createField = require('../createField');

var _createField2 = _interopRequireDefault(_createField);

var _createFields = require('../createFields');

var _createFields2 = _interopRequireDefault(_createFields);

var _createFieldArray = require('../createFieldArray');

var _createFieldArray2 = _interopRequireDefault(_createFieldArray);

var _FormSection = require('../FormSection');

var _FormSection2 = _interopRequireDefault(_FormSection);

var _plain = require('../structure/plain');

var _plain2 = _interopRequireDefault(_plain);

var _expectations = require('../structure/plain/expectations');

var _expectations2 = _interopRequireDefault(_expectations);

var _immutable = require('../structure/immutable');

var _immutable2 = _interopRequireDefault(_immutable);

var _expectations3 = require('../structure/immutable/expectations');

var _expectations4 = _interopRequireDefault(_expectations3);

var _addExpectations = require('./addExpectations');

var _addExpectations2 = _interopRequireDefault(_addExpectations);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* eslint react/no-multi-comp:0 */


var describeFormSection = function describeFormSection(name, structure, combineReducers, expect) {
  var reduxForm = (0, _createReduxForm2.default)(structure);
  var Field = (0, _createField2.default)(structure);
  var Fields = (0, _createFields2.default)(structure);
  var FieldArray = (0, _createFieldArray2.default)(structure);
  var reducer = (0, _createReducer2.default)(structure);
  var fromJS = structure.fromJS;

  var makeStore = function makeStore(initial) {
    return (0, _redux.createStore)(combineReducers({ form: reducer }), fromJS({ form: initial }));
  };

  describe(name, function () {
    it('should throw an error if not in ReduxForm', function () {
      expect(function () {
        _testUtils2.default.renderIntoDocument(_react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_FormSection2.default, { name: 'foo' })
        ));
      }).toThrow(/must be inside a component decorated with reduxForm/);
    });

    it('should not wrap in unnecessary div', function () {
      var store = makeStore({
        testForm: {
          values: {
            foo: {
              bar: '42'
            }
          }
        }
      });

      var Form = function (_Component) {
        _inherits(Form, _Component);

        function Form() {
          _classCallCheck(this, Form);

          return _possibleConstructorReturn(this, (Form.__proto__ || Object.getPrototypeOf(Form)).apply(this, arguments));
        }

        _createClass(Form, [{
          key: 'render',
          value: function render() {
            return _react2.default.createElement(
              _FormSection2.default,
              { name: 'foo' },
              _react2.default.createElement(Field, { name: 'bar', component: 'input' })
            );
          }
        }]);

        return Form;
      }(_react.Component);

      var TestForm = reduxForm({ form: 'testForm' })(Form);
      var dom = _testUtils2.default.renderIntoDocument(_react2.default.createElement(
        _reactRedux.Provider,
        { store: store },
        _react2.default.createElement(TestForm, null)
      ));

      var divTags = _testUtils2.default.scryRenderedDOMComponentsWithTag(dom, 'div');

      expect(divTags.length).toEqual(0);
    });

    it('should pass along unused props to div', function () {
      var store = makeStore({
        testForm: {
          values: {
            foo: {
              bar: '42'
            }
          }
        }
      });

      var Form = function (_Component2) {
        _inherits(Form, _Component2);

        function Form() {
          _classCallCheck(this, Form);

          return _possibleConstructorReturn(this, (Form.__proto__ || Object.getPrototypeOf(Form)).apply(this, arguments));
        }

        _createClass(Form, [{
          key: 'render',
          value: function render() {
            return _react2.default.createElement(
              _FormSection2.default,
              {
                name: 'foo',
                component: 'section',
                className: 'form-section',
                style: { fontWeight: 'bold' }
              },
              _react2.default.createElement(Field, { name: 'bar', component: 'input' }),
              _react2.default.createElement(Field, { name: 'baz', component: 'input' })
            );
          }
        }]);

        return Form;
      }(_react.Component);

      var TestForm = reduxForm({ form: 'testForm' })(Form);
      var dom = _testUtils2.default.renderIntoDocument(_react2.default.createElement(
        _reactRedux.Provider,
        { store: store },
        _react2.default.createElement(TestForm, null)
      ));

      var section = _testUtils2.default.findRenderedDOMComponentWithTag(dom, 'section');

      // 🤢 This line is DISGUSTING!! Is there a better way to get the props on the <section> ??
      var props = section[Object.keys(section)[0]]._currentElement.props;

      expect(props.name).toNotExist();
      expect(props.component).toNotExist();
      expect(props.className).toBe('form-section');
      expect(props.style).toExist();
      expect(props.style.fontWeight).toBe('bold');
    });

    it('should update Field values at the right depth', function () {
      var store = makeStore({
        testForm: {
          values: {
            foo: {
              bar: '42'
            }
          }
        }
      });
      var input = (0, _expect.createSpy)(function (props) {
        return _react2.default.createElement('input', props.input);
      }).andCallThrough();

      var Form = function (_Component3) {
        _inherits(Form, _Component3);

        function Form() {
          _classCallCheck(this, Form);

          return _possibleConstructorReturn(this, (Form.__proto__ || Object.getPrototypeOf(Form)).apply(this, arguments));
        }

        _createClass(Form, [{
          key: 'render',
          value: function render() {
            return _react2.default.createElement(
              _FormSection2.default,
              { name: 'foo' },
              _react2.default.createElement(Field, { name: 'bar', component: input })
            );
          }
        }]);

        return Form;
      }(_react.Component);

      var TestForm = reduxForm({ form: 'testForm' })(Form);
      _testUtils2.default.renderIntoDocument(_react2.default.createElement(
        _reactRedux.Provider,
        { store: store },
        _react2.default.createElement(TestForm, null)
      ));

      // input displaying string value
      expect(input.calls.length).toBe(1);
      expect(input.calls[0].arguments[0].input.value).toBe('42');

      // update value
      input.calls[0].arguments[0].input.onChange('15');

      // input displaying updated string value
      expect(input.calls.length).toBe(2);
      expect(input.calls[1].arguments[0].input.value).toBe('15');

      expect(store.getState()).toEqualMap({
        form: {
          testForm: {
            values: {
              foo: {
                bar: '15'
              }
            },
            registeredFields: {
              'foo.bar': { name: 'foo.bar', type: 'Field', count: 1 }
            }
          }
        }
      });
    });

    it('should update Fields values at the right depth', function () {
      var store = makeStore({
        testForm: {
          values: {
            foo: {
              bar: '42',
              baz: '100'
            }
          }
        }
      });
      var input = (0, _expect.createSpy)(function (props) {
        return _react2.default.createElement('input', props.bar.input);
      }).andCallThrough();

      var Form = function (_Component4) {
        _inherits(Form, _Component4);

        function Form() {
          _classCallCheck(this, Form);

          return _possibleConstructorReturn(this, (Form.__proto__ || Object.getPrototypeOf(Form)).apply(this, arguments));
        }

        _createClass(Form, [{
          key: 'render',
          value: function render() {
            return _react2.default.createElement(
              _FormSection2.default,
              { name: 'foo' },
              _react2.default.createElement(Fields, { names: ['bar', 'baz'], component: input })
            );
          }
        }]);

        return Form;
      }(_react.Component);

      var TestForm = reduxForm({ form: 'testForm' })(Form);
      _testUtils2.default.renderIntoDocument(_react2.default.createElement(
        _reactRedux.Provider,
        { store: store },
        _react2.default.createElement(TestForm, null)
      ));

      // input displaying string value
      expect(input.calls.length).toBe(1);
      expect(input.calls[0].arguments[0].bar.input.value).toBe('42');
      expect(input.calls[0].arguments[0].baz.input.value).toBe('100');

      // update value
      input.calls[0].arguments[0].bar.input.onChange('15');

      // input displaying updated string value
      expect(input.calls.length).toBe(2);
      expect(input.calls[1].arguments[0].bar.input.value).toBe('15');

      expect(store.getState()).toEqualMap({
        form: {
          testForm: {
            values: {
              foo: {
                bar: '15',
                baz: '100'
              }
            },
            registeredFields: {
              'foo.bar': { name: 'foo.bar', type: 'Field', count: 1 },
              'foo.baz': { name: 'foo.baz', type: 'Field', count: 1 }
            }
          }
        }
      });
    });

    it('should update FieldArray values at the right depth', function () {
      var store = makeStore({
        testForm: {
          values: {
            foo: {
              bar: ['dog', 'cat']
            }
          }
        }
      });

      var renderField = (0, _expect.createSpy)(function (props) {
        return _react2.default.createElement('input', props.input);
      }).andCallThrough();
      var renderFieldArray = (0, _expect.createSpy)(function (_ref) {
        var fields = _ref.fields;
        return _react2.default.createElement(
          'div',
          null,
          fields.map(function (field) {
            return _react2.default.createElement(Field, { name: field, component: renderField, key: field });
          }),
          _react2.default.createElement(
            'button',
            { className: 'add', onClick: function onClick() {
                return fields.push('fish');
              } },
            'Add Dog'
          ),
          _react2.default.createElement(
            'button',
            { className: 'remove', onClick: function onClick() {
                return fields.pop();
              } },
            'Remove Dog'
          )
        );
      }).andCallThrough();

      var Form = function (_Component5) {
        _inherits(Form, _Component5);

        function Form() {
          _classCallCheck(this, Form);

          return _possibleConstructorReturn(this, (Form.__proto__ || Object.getPrototypeOf(Form)).apply(this, arguments));
        }

        _createClass(Form, [{
          key: 'render',
          value: function render() {
            return _react2.default.createElement(
              _FormSection2.default,
              { name: 'foo' },
              _react2.default.createElement(FieldArray, { name: 'bar', component: renderFieldArray })
            );
          }
        }]);

        return Form;
      }(_react.Component);

      var TestForm = reduxForm({ form: 'testForm' })(Form);
      var dom = _testUtils2.default.renderIntoDocument(_react2.default.createElement(
        _reactRedux.Provider,
        { store: store },
        _react2.default.createElement(TestForm, null)
      ));

      var addButton = _testUtils2.default.findRenderedDOMComponentWithClass(dom, 'add');
      var removeButton = _testUtils2.default.findRenderedDOMComponentWithClass(dom, 'remove');
      _testUtils2.default.Simulate.click(addButton);

      expect(store.getState()).toEqualMap({
        form: {
          testForm: {
            values: {
              foo: {
                bar: ['dog', 'cat', 'fish']
              }
            },
            registeredFields: {
              'foo.bar': { name: 'foo.bar', type: 'FieldArray', count: 1 },
              'foo.bar[0]': { name: 'foo.bar[0]', type: 'Field', count: 1 },
              'foo.bar[1]': { name: 'foo.bar[1]', type: 'Field', count: 1 },
              'foo.bar[2]': { name: 'foo.bar[2]', type: 'Field', count: 1 }
            }
          }
        }
      });

      _testUtils2.default.Simulate.click(removeButton);

      expect(store.getState()).toEqualMap({
        form: {
          testForm: {
            values: {
              foo: {
                bar: ['dog', 'cat']
              }
            },
            registeredFields: {
              'foo.bar': { name: 'foo.bar', type: 'FieldArray', count: 1 },
              'foo.bar[0]': { name: 'foo.bar[0]', type: 'Field', count: 1 },
              'foo.bar[1]': { name: 'foo.bar[1]', type: 'Field', count: 1 }
            }
          }
        }
      });
    });

    it('should concatenate prefixes when nested', function () {
      var store = makeStore({
        testForm: {
          values: {
            deep: {
              foo: {
                bar: '42'
              }
            }
          }
        }
      });
      var input = (0, _expect.createSpy)(function (props) {
        return _react2.default.createElement('input', props.input);
      }).andCallThrough();

      var Form = function (_Component6) {
        _inherits(Form, _Component6);

        function Form() {
          _classCallCheck(this, Form);

          return _possibleConstructorReturn(this, (Form.__proto__ || Object.getPrototypeOf(Form)).apply(this, arguments));
        }

        _createClass(Form, [{
          key: 'render',
          value: function render() {
            return _react2.default.createElement(
              _FormSection2.default,
              { name: 'deep' },
              _react2.default.createElement(
                _FormSection2.default,
                { name: 'foo' },
                _react2.default.createElement(Field, { name: 'bar', component: input })
              )
            );
          }
        }]);

        return Form;
      }(_react.Component);

      var TestForm = reduxForm({ form: 'testForm' })(Form);
      _testUtils2.default.renderIntoDocument(_react2.default.createElement(
        _reactRedux.Provider,
        { store: store },
        _react2.default.createElement(TestForm, null)
      ));

      // input gets the correct name and value
      expect(input).toHaveBeenCalled();
      expect(input.calls.length).toBe(1);
      expect(input.calls[0].arguments[0].input.value).toBe('42');
      expect(input.calls[0].arguments[0].input.name).toBe('deep.foo.bar');
    });
  });
};

describeFormSection('FormSection.plain', _plain2.default, _redux.combineReducers, (0, _addExpectations2.default)(_expectations2.default));
describeFormSection('FormSection.immutable', _immutable2.default, _reduxImmutablejs.combineReducers, (0, _addExpectations2.default)(_expectations4.default));