import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/objectWithoutPropertiesLoose";

var createFieldArrayProps = function createFieldArrayProps(_ref, name, form, sectionPrefix, getValue, _ref2) {
  var getIn = _ref.getIn;

  var arrayInsert = _ref2.arrayInsert,
      arrayMove = _ref2.arrayMove,
      arrayPop = _ref2.arrayPop,
      arrayPush = _ref2.arrayPush,
      arrayRemove = _ref2.arrayRemove,
      arrayRemoveAll = _ref2.arrayRemoveAll,
      arrayShift = _ref2.arrayShift,
      arraySplice = _ref2.arraySplice,
      arraySwap = _ref2.arraySwap,
      arrayUnshift = _ref2.arrayUnshift,
      asyncError = _ref2.asyncError,
      dirty = _ref2.dirty,
      length = _ref2.length,
      pristine = _ref2.pristine,
      submitError = _ref2.submitError,
      state = _ref2.state,
      submitFailed = _ref2.submitFailed,
      submitting = _ref2.submitting,
      syncError = _ref2.syncError,
      syncWarning = _ref2.syncWarning,
      value = _ref2.value,
      props = _ref2.props,
      rest = _objectWithoutPropertiesLoose(_ref2, ["arrayInsert", "arrayMove", "arrayPop", "arrayPush", "arrayRemove", "arrayRemoveAll", "arrayShift", "arraySplice", "arraySwap", "arrayUnshift", "asyncError", "dirty", "length", "pristine", "submitError", "state", "submitFailed", "submitting", "syncError", "syncWarning", "value", "props"]);

  var error = syncError || asyncError || submitError;
  var warning = syncWarning;
  var fieldName = sectionPrefix ? name.replace(sectionPrefix + ".", '') : name;

  var finalProps = _extends({
    fields: {
      _isFieldArray: true,
      forEach: function forEach(callback) {
        return (value || []).forEach(function (item, index) {
          return callback(fieldName + "[" + index + "]", index, finalProps.fields);
        });
      },
      get: getValue,
      getAll: function getAll() {
        return value;
      },
      insert: arrayInsert,
      length: length,
      map: function map(callback) {
        return (value || []).map(function (item, index) {
          return callback(fieldName + "[" + index + "]", index, finalProps.fields);
        });
      },
      move: arrayMove,
      name: name,
      pop: function pop() {
        arrayPop();
        return getIn(value, String(length - 1));
      },
      push: arrayPush,
      reduce: function reduce(callback, initial) {
        return (value || []).reduce(function (accumulator, item, index) {
          return callback(accumulator, fieldName + "[" + index + "]", index, finalProps.fields);
        }, initial);
      },
      remove: arrayRemove,
      removeAll: arrayRemoveAll,
      shift: function shift() {
        arrayShift();
        return getIn(value, '0');
      },
      splice: arraySplice,
      swap: arraySwap,
      unshift: arrayUnshift
    },
    meta: {
      dirty: dirty,
      error: error,
      form: form,
      warning: warning,
      invalid: !!error,
      pristine: pristine,
      submitting: submitting,
      submitFailed: submitFailed,
      valid: !error
    }
  }, props, rest);

  return finalProps;
};

export default createFieldArrayProps;