'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports['default'] = debounce;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _lodashDebounce = require('lodash.debounce');

var _lodashDebounce2 = _interopRequireDefault(_lodashDebounce);

function debounce(wait, options) {
  var finalOptions = typeof options === 'number' ? { maxWait: options } : options;

  return function (storage) {
    return _extends({}, storage, {
      put: (0, _lodashDebounce2['default'])(storage.put, wait, finalOptions)
    });
  };
}

module.exports = exports['default'];