'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports['default'] = persistState;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _redux = require('redux');

var _persistStateMiddlewareJs = require('./persistStateMiddleware.js');

var _persistStateMiddlewareJs2 = _interopRequireDefault(_persistStateMiddlewareJs);

var _bufferActionsJs = require('./bufferActions.js');

var _bufferActionsJs2 = _interopRequireDefault(_bufferActionsJs);

var _actionTypesJs = require('./actionTypes.js');

var _actionTypesJs2 = _interopRequireDefault(_actionTypesJs);

var _adaptersLocalStorage = require('./adapters/localStorage');

var _adaptersLocalStorage2 = _interopRequireDefault(_adaptersLocalStorage);

var defaultKey = 'redux-localstorage';
var getDefaultStorage = function getDefaultStorage() {
  (0, _adaptersLocalStorage2['default'])(window.localStorage);
};

/**
 * @description
 * persistState is a Store Enhancer that persists store changes.
 *
 * @param {Object} [storage = adapter(localStorage)] Object used to interface with any type of storage back-end.
 * @param {String} [key = "redux-localstorage"] String used as storage key.
 * @param {Function} [callback] Called when persistState has finished initializing.
 *
 * @returns {Function} An enhanced create store function.
 */

function persistState(storage, key, callback) {
  if (storage === undefined) storage = getDefaultStorage();
  if (key === undefined) key = defaultKey;

  var finalStorage = storage;
  var finalKey = key;
  var finalCallback = callback;

  // Juggle arguments if needed
  if (typeof key === 'function') {
    finalCallback = key;
    finalKey = defaultKey;
  }

  if (typeof storage === 'string') {
    finalKey = storage;
    finalStorage = getDefaultStorage();
  } else if (typeof storage === 'function') {
    finalCallback = storage;
    finalStorage = getDefaultStorage();
  }

  return function (createStore) {
    return function () {
      var enhancer = (0, _redux.applyMiddleware)((0, _bufferActionsJs2['default'])(), (0, _persistStateMiddlewareJs2['default'])(finalStorage, finalKey));

      var store = enhancer(createStore).apply(undefined, arguments);

      // Retrieve and dispatch persisted store state
      finalStorage.get(finalKey, function (err, persistedState) {
        if (err) console.error('Failed to retrieve persisted state from storage:', err); // eslint-disable-line no-console

        store.dispatch({
          type: _actionTypesJs2['default'].INIT,
          payload: persistedState
        });

        if (finalCallback) finalCallback();
      });

      return store;
    };
  };
}

module.exports = exports['default'];