/**
 * Composes functions from left to right.
 *
 * @param {...Function} funcs - The functions to compose. Each is expected to
 * accept a function as an argument and to return a function.
 * @returns {Function} A function obtained by composing functions from left to
 * right.
 */
"use strict";

exports.__esModule = true;
exports["default"] = compose;

function compose() {
  for (var _len = arguments.length, funcs = Array(_len), _key = 0; _key < _len; _key++) {
    funcs[_key] = arguments[_key];
  }

  return funcs.reduceRight(function (composed, f) {
    return f(composed);
  });
}

module.exports = exports["default"];