'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var stores = new WeakMap();

var reedux = function reedux(store, existingReducer) {
  var _ref = stores.get(store) || {
    currentStorePaths: {},
    reducersByStorePath: {},
    reducersByActionType: {},
    combinedReducer: function combinedReducer(s) {
      return s;
    }
  },
      currentStorePaths = _ref.currentStorePaths,
      reducersByStorePath = _ref.reducersByStorePath,
      reducersByActionType = _ref.reducersByActionType,
      combinedReducer = _ref.combinedReducer;

  stores.set(store, {
    currentStorePaths: currentStorePaths,
    reducersByStorePath: reducersByStorePath,
    reducersByActionType: reducersByActionType,
    combinedReducer: existingReducer || combinedReducer
  });

  // addStorePath
  return function (storePathName, initialState) {
    // this is the store level reducer - which looks for store path level reducers
    currentStorePaths[storePathName] = function () {
      var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
      var action = arguments[1];
      var type = action.type;

      var newState = state;

      // execute reducers by type if any
      if (reducersByActionType[storePathName][type]) {
        newState = reducersByActionType[storePathName][type].reduce(function (state, reducer) {
          return reducer(state, action);
        }, newState);
      }

      // execute store path level reducers if any
      if (reducersByStorePath[storePathName].length) {
        return reducersByStorePath[storePathName].reduce(function (state, reducer) {
          return reducer(state, action);
        }, newState);
      }
      return newState;
    };

    // store path level reducers, by action type
    reducersByStorePath[storePathName] = reducersByStorePath[storePathName] || [];
    reducersByActionType[storePathName] = reducersByActionType[storePathName] || {};

    // now everything is set up properly and we can replace the reducers on the store
    store.replaceReducer(function () {
      var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var action = arguments[1];

      var staticReducer = existingReducer || combinedReducer;
      var nextState = staticReducer(state, action);
      var hasChanges = state !== nextState;
      nextState = Object.keys(currentStorePaths).reduce(function (incompleteState, storePath) {
        var reducer = currentStorePaths[storePath];
        var currentStorePathState = nextState[storePath];
        var newStorePathState = reducer(currentStorePathState, action);
        hasChanges = hasChanges || currentStorePathState !== newStorePathState;

        // @TODO - use the spread operator as soon as travis updates their node version
        var nextIncompleteState = Object.assign({}, incompleteState);
        nextIncompleteState[storePath] = newStorePathState;
        return nextIncompleteState;
      }, Object.assign({}, nextState));

      return hasChanges ? nextState : state;
    });

    // the setup allows reducers registration both ways:
    // - addReducer((state, action) => { switch(action.type) {...} }
    // - addReducer(type, (state, action) => {...})
    return function () {
      for (var _len = arguments.length, params = Array(_len), _key = 0; _key < _len; _key++) {
        params[_key] = arguments[_key];
      }

      var actionType = params[0],
          reducer = params[1];

      if (typeof actionType === 'function') {
        reducer = actionType;
        actionType = undefined;
      }

      if (actionType) {
        reducersByActionType[storePathName][actionType] = reducersByActionType[storePathName][actionType] || [];
        reducersByActionType[storePathName][actionType].push(reducer);
      } else {
        reducersByStorePath[storePathName].push(reducer);
      }
    };
  };
};

// UMD
(function (global, factory) {
  (typeof exports === 'undefined' ? 'undefined' : _typeof(exports)) === 'object' && typeof module !== 'undefined' ? factory(exports) : typeof define === 'function' && define.amd ? define(['exports'], factory) : factory(global.reedux = global.reedux || {});
})(undefined, function (exports) {
  exports.default = reedux;
  Object.defineProperty(exports, '__esModule', { value: true });
});
