# regex-flags [![NPM version](https://badge.fury.io/js/regex-flags.svg)](http://badge.fury.io/js/regex-flags)

> Does one simple thing - gets the flags from a regular expression. Useful for cloning and any library that uses or generates regular expressions that are created from other regular expressions.

If you need a "ES6 spec-compliant `RegExp.prototype.flags` shim, take a look at the [RegExp.prototype.flags](https://github.com/es-shims/RegExp.prototype.flags) lib, from @ljharb.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i regex-flags --save
```

## Usage

```js
var regexFlags = require('regex-flags');

regexFlags(/foo/);
//=> ''

regexFlags(/foo/g);
//=> 'g'

regexFlags(/foo/m);
//=> 'm'

regexFlags(/foo/i);
//=> 'i'

regexFlags(/foo/gm);
//=> 'gm'

regexFlags(/foo/gi);
//=> 'gi'

regexFlags(/foo/img);
//=> 'gim'

regexFlags(/foo/gim);
//=> 'gim'

regexFlags(/foo/gim);
//=> 'gim'
```

## Related projects

* [is-glob](https://github.com/jonschlinkert/is-glob): Returns `true` if the given string looks like a glob pattern.
* [is-equal-regex](https://github.com/jonschlinkert/is-equal-regex): Returns true if regular expression A is equal to regex B. Compares the expression and… [more](https://github.com/jonschlinkert/is-equal-regex)
* [regex-cache](https://github.com/jonschlinkert/regex-cache): Memoize the results of a call to the RegExp constructor, avoiding repetitious runtime compilation of… [more](https://github.com/jonschlinkert/regex-cache)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/regex-flags/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on August 05, 2015._