'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('cerebral/react');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Create a HOC factory for the given Cerebral controller.
 *
 * The factory wraps the given component in a Cerebral/React container and assigns the controller instance.
 */
function ControllerConnector(controller) {
  return function ControllerConnectorHocFactory(Component) {
    return function RemaceHocContainer(props) {
      return _react2.default.createElement(
        _react3.Container,
        { controller: controller },
        _react2.default.createElement(Component, props)
      );
    };
  };
}

exports.default = ControllerConnector;
//# sourceMappingURL=ControllerConnector.js.map