'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _reactHabitat = require('react-habitat');

var _reactHabitat2 = _interopRequireDefault(_reactHabitat);

var _ControllerConnector = require('./ControllerConnector');

var _ControllerConnector2 = _interopRequireDefault(_ControllerConnector);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Create a ReactHabitat.Container.
 *
 * - Connects given Components to the Cerebral controller.
 * - Registers connected Components in a Habitat container.
 */
function RehaceContainer(_ref) {
  var controller = _ref.controller,
      components = _ref.components;

  var connect = (0, _ControllerConnector2.default)(controller);
  var container = new _reactHabitat2.default.Container();

  Object.keys(components).forEach(function (key) {
    var connectedComponent = connect(components[key]);
    container.register(key, connectedComponent);
  });

  return container;
}

exports.default = RehaceContainer;
//# sourceMappingURL=RehaceContainer.js.map