import { type Root } from 'hast';
import { type Plugin } from 'unified';
export interface RehypeMdxImportMediaOptions {
    /**
     * HTML element attributes that should be processed. The key is the HTML element tag name. The
     * value is a list of attribute names to process. The default value is {@link defaultAttributes}
     */
    attributes?: Record<string, Iterable<string>>;
    /**
     * The casing to use for attribute names.
     *
     * This should match the `elementAttributeNameCase` value passed to MDX.
     *
     * @default 'react'
     * @see https://mdxjs.com/packages/mdx/#processoroptions
     */
    elementAttributeNameCase?: 'html' | 'react';
    /**
     * Where to keep URL hash.
     *
     * - `both`: Keep the URL hash on both the import source and the JSX prop.
     * - `import`: Only keep the URL hash on the import source.
     * - `jsx`: Only keep the URL hash on the JSX prop.
     * - `none`: Remove the URL hash.
     *
     * @default 'import'
     */
    preserveHash?: 'both' | 'import' | 'jsx' | 'none';
    /**
     * Where to keep query parameters.
     *
     * - `both`: Keep the query parameters on both the import source and the JSX prop.
     * - `import`: Only keep the query parameters on the import source.
     * - `jsx`: Only keep the query parameters on the JSX prop.
     * - `none`: Remove the query parameters.
     *
     * @default 'import'
     */
    preserveQuery?: 'both' | 'import' | 'jsx' | 'none';
    /**
     * By default imports are resolved relative to the input file. This matches default markdown
     * behaviour. If this is set to false, this behaviour is removed and URLs are no longer processed.
     * This allows to import images from `node_modules`. If this is disabled, local images can still
     * be imported by prepending the path with `./`.
     *
     * @default true
     */
    resolve?: boolean;
}
export declare const defaultAttributes: Record<string, Iterable<string>>;
/**
 * A rehype MDX plugin for converting media sources into imports.
 */
declare const rehypeMdxImportMedia: Plugin<[RehypeMdxImportMediaOptions?], Root>;
export default rehypeMdxImportMedia;
//# sourceMappingURL=rehype-mdx-import-media.d.ts.map