"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultLocale = getDefaultLocale;
exports.setDefaultLocale = setDefaultLocale;
exports.getLocaleData = getLocaleData;
exports.addLocaleData = addLocaleData;
// Fallback locale.
// (when not a single one of the supplied "preferred" locales is available)
var defaultLocale = 'en'; // For all locales added
// their relative time formatter messages will be stored here.

var localesData = {};

function getDefaultLocale() {
  return defaultLocale;
}

function setDefaultLocale(locale) {
  defaultLocale = locale;
} // export function isLocaleDataAvailable(locale) {
//  return localesData.hasOwnProperty(locale)
// }


function getLocaleData(locale) {
  return localesData[locale];
}

function addLocaleData(localeData) {
  if (!localeData) {
    throw new Error('No locale data passed');
  } // This locale data is stored in a global variable
  // and later used when calling `.format(time)`.


  localesData[localeData.locale] = localeData;
}
//# sourceMappingURL=LocaleDataStore.js.map