"use strict";

var _resolveLocale = _interopRequireDefault(require("./resolveLocale"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('resolveLocale', function () {
  it('should resolve locale', function () {
    (0, _resolveLocale.default)("en-XX").should.equal("en");
  });
  it('should throw when "localeMatcher" option is not a valid one', function () {
    expect(function () {
      return (0, _resolveLocale.default)("en", {
        localeMatcher: "eccentric"
      });
    }).to.throw('Invalid "localeMatcher" option');
  });
  it('should fall back to "lookup" when passed "best fit" "localeMatcher" option', function () {
    (0, _resolveLocale.default)("en-XX", {
      localeMatcher: "best fit"
    }).should.equal("en");
  });
});
//# sourceMappingURL=resolveLocale.test.js.map