import resolveLocale from './resolveLocale';
describe('resolveLocale', function () {
  it('should resolve locale', function () {
    resolveLocale("en-XX").should.equal("en");
  });
  it('should throw when "localeMatcher" option is not a valid one', function () {
    expect(function () {
      return resolveLocale("en", {
        localeMatcher: "eccentric"
      });
    }).to.throw('Invalid "localeMatcher" option');
  });
  it('should fall back to "lookup" when passed "best fit" "localeMatcher" option', function () {
    resolveLocale("en-XX", {
      localeMatcher: "best fit"
    }).should.equal("en");
  });
});
//# sourceMappingURL=resolveLocale.test.js.map