import { type Root } from 'mdast';
import { type Plugin } from 'unified';
import { define } from 'unist-util-mdx-define';
type FrontmatterParsers = Record<string, (value: string) => unknown>;
export interface RemarkMdxFrontmatterOptions extends define.Options {
    /**
     * If specified, the YAML data is exported using this name. Otherwise, each
     * object key will be used as an export name.
     */
    name?: string;
    /**
     * A mapping of node types to parsers.
     *
     * Each key represents a frontmatter node type. The value is a function that accepts the
     * frontmatter data as a string, and returns the parsed data.
     *
     * By default `yaml` nodes will be parsed using [`yaml`](https://github.com/eemeli/yaml) and
     * `toml` nodes using [`toml`](https://github.com/BinaryMuse/toml-node).
     */
    parsers?: FrontmatterParsers;
}
/**
 * A remark plugin to expose frontmatter data as named exports.
 *
 * @param options Optional options to configure the output.
 * @returns A unified transformer.
 */
declare const remarkMdxFrontmatter: Plugin<[RemarkMdxFrontmatterOptions?], Root>;
export default remarkMdxFrontmatter;
//# sourceMappingURL=remark-mdx-frontmatter.d.ts.map