# Core rules

The core rules are the one managing global parsing or Markdown syntaxes
requiring a global access to the document. For example, management of reference
links or abbreviations. They are also the one triggering the execution of
[block][block] and [inline][inline] rules.

A core rule is a function expecting a single `StateCore` argument. The code for
the StateCore prototype is in [`index.js`](../lib/index.js) and its data consists
of:

* `src`: the complete string the parser is currently working on
* `tokens`: the tokens generated by the previous core rules, up to now
* `env`: a namespaced data key-value store to allow core rules to exchange data
* `inlineMode`: a flag mentionning whether the parser is currently working as inline-mode only
  or standard mode

The rest are mostly components of the underlying remarkable instance.

Some core rules process directly the `src` to produce a new set of tokens,
others process the existing list of tokens in order to produce a new one.

The most important predefined core rules are `block` and `inline` which are
reponsible for calling the subparsers for the [block][block] and
[inline][inline] rules.

To better understand how the core rules work, please read the code in
[`parser_core.js`](../lib/parser_core.js) and the predefined rules in
[`rules_core/`](../lib/rules_core/).

[inline]: parsing_inline.js
[block]: parsing_block.js
