/** A standard selector function, which takes three generic type arguments:
 * @param State The first value, often a Redux root state object
 * @param Result The final result returned by the selector
 * @param Params All additional arguments passed into the selector
 */
export declare type Selector<State = any, Result = unknown, Params extends never | readonly any[] = any[]> = [Params] extends [never] ? (state: State) => Result : (state: State, ...params: Params) => Result;
/** Selectors generated by Reselect have several additional fields attached: */
interface OutputSelectorFields<Combiner, Result> {
    /** The final function passed to `createSelector` */
    resultFunc: Combiner;
    /** The same function, memoized */
    memoizedResultFunc: Combiner;
    /** Returns the last result calculated by the selector */
    lastResult: () => Result;
    /** An array of the input selectors */
    dependencies: SelectorArray;
    /** Counts the number of times the output has been recalculated */
    recomputations: () => number;
    /** Resets the count of recomputations count to 0 */
    resetRecomputations: () => number;
}
/** Represents the actual selectors generated by `createSelector`.
 * The selector is:
 * - "a function that takes this state + params and returns a result"
 * - plus the attached additional fields
 */
export declare type OutputSelector<S extends SelectorArray, Result, Combiner, Params extends readonly any[] = never> = Selector<GetStateFromSelectors<S>, Result, Params> & OutputSelectorFields<Combiner, Result>;
/** A selector that is assumed to have one additional argument, such as
 * the props from a React component
 */
export declare type ParametricSelector<State, Props, Result> = Selector<State, Result, [
    Props,
    ...any
]>;
/** A generated selector that is assumed to have one additional argument */
export declare type OutputParametricSelector<State, Props, Result, Combiner> = ParametricSelector<State, Props, Result> & OutputSelectorFields<Combiner, Result>;
/** An array of input selectors */
export declare type SelectorArray = ReadonlyArray<Selector>;
/** Utility type to extract the State generic from a selector */
declare type GetStateFromSelector<S> = S extends Selector<infer State> ? State : never;
/** Utility type to extract the State generic from multiple selectors at once,
 * to help ensure that all selectors correctly share the same State type and
 * avoid mismatched input selectors being provided.
 */
export declare type GetStateFromSelectors<S extends SelectorArray> = S extends [infer C1, infer C2, ...infer Other] ? Other extends [any] ? GetStateFromSelector<C1> & GetStateFromSelector<C2> & GetStateFromSelectors<Other> : GetStateFromSelector<C1> & GetStateFromSelector<C2> : S extends [infer Current, ...infer Other] ? Other extends [any] ? GetStateFromSelector<Current> & GetStateFromSelectors<Other> : GetStateFromSelector<Current> : S extends (infer Elem)[] ? GetStateFromSelector<Elem> : never;
/** Utility type to extract the Params generic from a selector */
export declare type GetParamsFromSelector<S> = S extends Selector<any, any, infer P> ? P extends [] ? never : P : never;
/** Utility type to extract the Params generic from multiple selectors at once,
 * to help ensure that all selectors correctly share the same params and
 * avoid mismatched input selectors being provided.
 */
export declare type GetParamsFromSelectors<S, Found = never> = S extends SelectorArray ? S extends (infer s)[] ? GetParamsFromSelector<s> : S extends [infer Current, ...infer Rest] ? GetParamsFromSelector<Current> extends [] ? GetParamsFromSelectors<Rest, Found> : GetParamsFromSelector<Current> : S : Found;
/** Utility type to extract the return type from a selector */
declare type SelectorReturnType<S> = S extends Selector ? ReturnType<S> : never;
/** Utility type to extract the Result generic from multiple selectors at once,
 * for use in calculating the arguments to the "result/combiner" function.
 */
export declare type SelectorResultArray<Selectors extends SelectorArray, Rest extends SelectorArray = Selectors> = Rest extends [infer S1, infer S2, ...infer Remaining] ? Remaining extends SelectorArray ? [
    SelectorReturnType<S1>,
    SelectorReturnType<S2>,
    ...SelectorResultArray<Selectors, Remaining>
] : [SelectorReturnType<S1>, SelectorReturnType<S2>] : Rest extends [infer S, ...infer Remaining] ? Remaining extends SelectorArray ? [SelectorReturnType<S>, ...SelectorResultArray<Selectors, Remaining>] : [SelectorReturnType<S>] : Rest extends ((...args: any) => infer S)[] ? S[] : [];
/** A standard function returning true if two values are considered equal */
export declare type EqualityFn = (a: any, b: any) => boolean;
/** Utility type to infer the type of "all params of a function except the first", so we can determine what arguments a memoize function accepts */
export declare type DropFirst<T extends unknown[]> = T extends [unknown, ...infer U] ? U : never;
export {};
