type UnknownFunction$1 = (...args: any[]) => any;
type LongestTuple<T extends readonly unknown[][]> = T extends [
    infer U extends unknown[]
] ? U : T extends [infer U, ...infer R extends unknown[][]] ? MostProperties<U, LongestTuple<R>> : never;
type MostProperties<T, U> = keyof U extends keyof T ? T : U;
type ElementAt<T extends unknown[], N extends keyof any> = N extends keyof T ? T[N] : unknown;
type ElementsAt<T extends readonly unknown[][], N extends keyof any> = {
    [K in keyof T]: ElementAt<T[K], N>;
};
type Intersect<T extends readonly unknown[]> = T extends [] ? unknown : T extends [infer H, ...infer T] ? H & Intersect<T> : T[number];
type MergeTuples<T extends readonly unknown[][], L extends unknown[] = LongestTuple<T>> = {
    [K in keyof L]: Intersect<ElementsAt<T, K>>;
};
type ExtractParameters<T extends readonly UnknownFunction$1[]> = {
    [K in keyof T]: Parameters<T[K]>;
};
type MergeParameters<T extends readonly UnknownFunction$1[]> = '0' extends keyof T ? MergeTuples<ExtractParameters<T>> : Parameters<T[number]>;

/** A standard selector function, which takes three generic type arguments:
 * @param State The first value, often a Redux root state object
 * @param Result The final result returned by the selector
 * @param Params All additional arguments passed into the selector
 */
type Selector<State = any, Result = unknown, Params extends never | readonly any[] = any[]> = [Params] extends [never] ? (state: State) => Result : (state: State, ...params: Params) => Result;
/** Selectors generated by Reselect have several additional fields attached: */
interface OutputSelectorFields<Combiner extends UnknownFunction, Keys> {
    /** The final function passed to `createSelector` */
    resultFunc: Combiner;
    /** The same function, memoized */
    memoizedResultFunc: Combiner & Keys;
    /** Returns the last result calculated by the selector */
    lastResult: () => ReturnType<Combiner>;
    /** An array of the input selectors */
    dependencies: SelectorArray;
    /** Counts the number of times the output has been recalculated */
    recomputations: () => number;
    /** Resets the count of recomputations count to 0 */
    resetRecomputations: () => number;
}
/** Represents the actual selectors generated by `createSelector`.
 * The selector is:
 * - "a function that takes this state + params and returns a result"
 * - plus the attached additional fields
 */
type OutputSelector<S extends SelectorArray, Result, Combiner extends UnknownFunction, Params extends readonly any[] = never, // MergeParameters<S>
Keys = {}> = Selector<GetStateFromSelectors<S>, Result, Params> & OutputSelectorFields<Combiner, Keys>;
/** A selector that is assumed to have one additional argument, such as
 * the props from a React component
 */
type ParametricSelector<State, Props, Result> = Selector<State, Result, [
    Props,
    ...any
]>;
/** A generated selector that is assumed to have one additional argument */
type OutputParametricSelector<State, Props, Result, Combiner extends UnknownFunction, Keys = {}> = ParametricSelector<State, Props, Result> & OutputSelectorFields<Combiner, Keys>;
/** An array of input selectors */
type SelectorArray = ReadonlyArray<Selector>;
/** A standard function returning true if two values are considered equal */
type EqualityFn = (a: any, b: any) => boolean;
/** Extracts an array of all return types from all input selectors */
type SelectorResultArray<Selectors extends SelectorArray> = ExtractReturnType<Selectors>;
/** Determines the combined single "State" type (first arg) from all input selectors */
type GetStateFromSelectors<S extends SelectorArray> = MergeParameters<S>[0];
/** Determines the combined  "Params" type (all remaining args) from all input selectors */
type GetParamsFromSelectors<S extends SelectorArray, RemainingItems extends readonly unknown[] = Tail<MergeParameters<S>>> = RemainingItems;
/** Any function with arguments */
type UnknownFunction = (...args: any[]) => any;
/** Extract the return type from all functions as a tuple */
type ExtractReturnType<T extends readonly UnknownFunction[]> = {
    [index in keyof T]: T[index] extends T[number] ? ReturnType<T[index]> : never;
};
/** First item in an array */
type Head<T> = T extends [any, ...any[]] ? T[0] : never;
/** All other items in an array */
type Tail<A> = A extends [any, ...infer Rest] ? Rest : never;
/** The infamous "convert a union type to an intersection type" hack
 * Source: https://github.com/sindresorhus/type-fest/blob/main/source/union-to-intersection.d.ts
 * Reference: https://github.com/microsoft/TypeScript/issues/29594
 */
type UnionToIntersection<Union> = (Union extends unknown ? (distributedUnion: Union) => void : never) extends (mergedIntersection: infer Intersection) => void ? Intersection : never;
/**
 * Code to convert a union of values into a tuple.
 * Source: https://stackoverflow.com/a/55128956/62937
 */
type Push<T extends any[], V> = [...T, V];
type LastOf<T> = UnionToIntersection<T extends any ? () => T : never> extends () => infer R ? R : never;
type TuplifyUnion<T, L = LastOf<T>, N = [T] extends [never] ? true : false> = true extends N ? [] : Push<TuplifyUnion<Exclude<T, L>>, L>;
/**
 * Converts "the values of an object" into a tuple, like a type-level `Object.values()`
 * Source: https://stackoverflow.com/a/68695508/62937
 */
type ObjValueTuple<T, KS extends any[] = TuplifyUnion<keyof T>, R extends any[] = []> = KS extends [infer K, ...infer KT] ? ObjValueTuple<T, KT, [...R, T[K & keyof T]]> : R;
/** Utility type to infer the type of "all params of a function except the first", so we can determine what arguments a memoize function accepts */
type DropFirst<T extends unknown[]> = T extends [unknown, ...infer U] ? U : never;
/**
 * Expand an item a single level, or recursively.
 * Source: https://stackoverflow.com/a/69288824/62937
 */
type Expand<T> = T extends (...args: infer A) => infer R ? (...args: Expand<A>) => Expand<R> : T extends infer O ? {
    [K in keyof O]: O[K];
} : never;

declare const defaultEqualityCheck: EqualityFn;
interface DefaultMemoizeOptions {
    equalityCheck?: EqualityFn;
    resultEqualityCheck?: EqualityFn;
    maxSize?: number;
}
declare function defaultMemoize<F extends (...args: any[]) => any>(func: F, equalityCheckOrOptions?: EqualityFn | DefaultMemoizeOptions): F & {
    clearCache: () => void;
};

declare function autotrackMemoize<F extends (...args: any[]) => any>(func: F): F & {
    clearCache: () => void;
};

declare function weakMapMemoize<F extends (...args: any[]) => any>(func: F): F & {
    clearCache: () => void;
};

type StabilityCheck = 'always' | 'once' | 'never';
declare function setInputStabilityCheckEnabled(enabled: StabilityCheck): void;
declare function createSelectorCreator<
/** Selectors will eventually accept some function to be memoized */
F extends (...args: unknown[]) => unknown, 
/** A memoizer such as defaultMemoize that accepts a function + some possible options */
MemoizeFunction extends (func: F, ...options: any[]) => F, 
/** The additional options arguments to the memoizer */
MemoizeOptions extends unknown[] = DropFirst<Parameters<MemoizeFunction>>>(memoize: MemoizeFunction, ...memoizeOptionsFromArgs: DropFirst<Parameters<MemoizeFunction>>): CreateSelectorFunction<F, MemoizeFunction, MemoizeOptions, Expand<Pick<ReturnType<MemoizeFunction>, keyof ReturnType<MemoizeFunction>>>>;
interface CreateSelectorOptions<MemoizeOptions extends unknown[]> {
    memoizeOptions?: MemoizeOptions[0] | MemoizeOptions;
    inputStabilityCheck?: StabilityCheck;
}
/**
 * An instance of createSelector, customized with a given memoize implementation
 */
interface CreateSelectorFunction<F extends (...args: unknown[]) => unknown, MemoizeFunction extends (func: F, ...options: any[]) => F, MemoizeOptions extends unknown[] = DropFirst<Parameters<MemoizeFunction>>, Keys = Expand<Pick<ReturnType<MemoizeFunction>, keyof ReturnType<MemoizeFunction>>>> {
    /** Input selectors as separate inline arguments */
    <Selectors extends SelectorArray, Result>(...items: [
        ...Selectors,
        (...args: SelectorResultArray<Selectors>) => Result
    ]): OutputSelector<Selectors, Result, (...args: SelectorResultArray<Selectors>) => Result, GetParamsFromSelectors<Selectors>, Keys> & Keys;
    /** Input selectors as separate inline arguments with memoizeOptions passed */
    <Selectors extends SelectorArray, Result>(...items: [
        ...Selectors,
        (...args: SelectorResultArray<Selectors>) => Result,
        CreateSelectorOptions<MemoizeOptions>
    ]): OutputSelector<Selectors, Result, (...args: SelectorResultArray<Selectors>) => Result, GetParamsFromSelectors<Selectors>, Keys> & Keys;
    /** Input selectors as a separate array */
    <Selectors extends SelectorArray, Result>(selectors: [...Selectors], combiner: (...args: SelectorResultArray<Selectors>) => Result, options?: CreateSelectorOptions<MemoizeOptions>): OutputSelector<Selectors, Result, (...args: SelectorResultArray<Selectors>) => Result, GetParamsFromSelectors<Selectors>, Keys> & Keys;
}
declare const createSelector: CreateSelectorFunction<(...args: unknown[]) => unknown, typeof defaultMemoize, [equalityCheckOrOptions?: EqualityFn | DefaultMemoizeOptions | undefined], {
    clearCache: () => void;
}>;
type SelectorsObject = {
    [key: string]: (...args: any[]) => any;
};
interface StructuredSelectorCreator {
    <SelectorMap extends SelectorsObject, SelectorParams = MergeParameters<ObjValueTuple<SelectorMap>>>(selectorMap: SelectorMap, selectorCreator?: CreateSelectorFunction<any, any, any>): (state: Head<SelectorParams>, ...params: Tail<SelectorParams>) => {
        [Key in keyof SelectorMap]: ReturnType<SelectorMap[Key]>;
    };
    <State, Result = State>(selectors: {
        [K in keyof Result]: Selector<State, Result[K], never>;
    }, selectorCreator?: CreateSelectorFunction<any, any, any>): Selector<State, Result, never>;
}
declare const createStructuredSelector: StructuredSelectorCreator;

export { CreateSelectorFunction, CreateSelectorOptions, DefaultMemoizeOptions, EqualityFn, GetParamsFromSelectors, GetStateFromSelectors, OutputParametricSelector, OutputSelector, OutputSelectorFields, ParametricSelector, Selector, SelectorArray, SelectorResultArray, StructuredSelectorCreator, autotrackMemoize, createSelector, createSelectorCreator, createStructuredSelector, defaultEqualityCheck, defaultMemoize, setInputStabilityCheckEnabled, weakMapMemoize };
