# resolve-dir [![NPM version](https://badge.fury.io/js/resolve-dir.svg)](http://badge.fury.io/js/resolve-dir)

> Resolve a directory that is either local, global or in the user's home directory.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i resolve-dir --save
```

## Usage

```js
var resolve = require('resolve-dir');
```

Returns a local directory path unchanged

```js
resolve('a')
//=> 'a'
```

Resolves the path to user home

```js
resolve('~')
//=> '/Users/jonschlinkert'
resolve('~/foo')
//=> '/Users/jonschlinkert/foo'
```

Resolves the path to global npm modules

```js
resolve('@')
//=> '/usr/local/lib/node_modules'
resolve('@/foo')
//=> '/usr/local/lib/node_modules/foo'
```

## Related projects

* [expand-tilde](https://www.npmjs.com/package/expand-tilde): Bash-like tilde expansion for node.js. Expands a leading tilde in a file path to the… [more](https://www.npmjs.com/package/expand-tilde) | [homepage](https://github.com/jonschlinkert/expand-tilde)
* [global-modules](https://www.npmjs.com/package/global-modules): The directory used by npm for globally installed npm modules. | [homepage](https://github.com/jonschlinkert/global-modules)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/resolve-dir/issues/new).

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on September 21, 2015._