(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.Loader = f()}})(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var MiniSignalBinding = (function () {
  function MiniSignalBinding(fn, once, thisArg) {
    if (once === undefined) once = false;

    _classCallCheck(this, MiniSignalBinding);

    this._fn = fn;
    this._once = once;
    this._thisArg = thisArg;
    this._next = this._prev = this._owner = null;
  }

  _createClass(MiniSignalBinding, [{
    key: 'detach',
    value: function detach() {
      if (this._owner === null) return false;
      this._owner.detach(this);
      return true;
    }
  }]);

  return MiniSignalBinding;
})();

function _addMiniSignalBinding(self, node) {
  if (!self._head) {
    self._head = node;
    self._tail = node;
  } else {
    self._tail._next = node;
    node._prev = self._tail;
    self._tail = node;
  }

  node._owner = self;

  return node;
}

var MiniSignal = (function () {
  function MiniSignal() {
    _classCallCheck(this, MiniSignal);

    this._head = this._tail = undefined;
  }

  _createClass(MiniSignal, [{
    key: 'handlers',
    value: function handlers() {
      var exists = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

      var node = this._head;

      if (exists) return !!node;

      var ee = [];

      while (node) {
        ee.push(node);
        node = node._next;
      }

      return ee;
    }
  }, {
    key: 'has',
    value: function has(node) {
      if (!(node instanceof MiniSignalBinding)) {
        throw new Error('MiniSignal#has(): First arg must be a MiniSignalBinding object.');
      }

      return node._owner === this;
    }
  }, {
    key: 'dispatch',
    value: function dispatch() {
      var node = this._head;

      if (!node) return false;

      while (node) {
        if (node._once) this.detach(node);
        node._fn.apply(node._thisArg, arguments);
        node = node._next;
      }

      return true;
    }
  }, {
    key: 'add',
    value: function add(fn) {
      var thisArg = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];

      if (typeof fn !== 'function') {
        throw new Error('MiniSignal#add(): First arg must be a Function.');
      }
      return _addMiniSignalBinding(this, new MiniSignalBinding(fn, false, thisArg));
    }
  }, {
    key: 'once',
    value: function once(fn) {
      var thisArg = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];

      if (typeof fn !== 'function') {
        throw new Error('MiniSignal#once(): First arg must be a Function.');
      }
      return _addMiniSignalBinding(this, new MiniSignalBinding(fn, true, thisArg));
    }
  }, {
    key: 'detach',
    value: function detach(node) {
      if (!(node instanceof MiniSignalBinding)) {
        throw new Error('MiniSignal#detach(): First arg must be a MiniSignalBinding object.');
      }
      if (node._owner !== this) return this;

      if (node._prev) node._prev._next = node._next;
      if (node._next) node._next._prev = node._prev;

      if (node === this._head) {
        this._head = node._next;
        if (node._next === null) {
          this._tail = null;
        }
      } else if (node === this._tail) {
        this._tail = node._prev;
        this._tail._next = null;
      }

      node._owner = null;
      return this;
    }
  }, {
    key: 'detachAll',
    value: function detachAll() {
      var node = this._head;
      if (!node) return this;

      this._head = this._tail = null;

      while (node) {
        node._owner = null;
        node = node._next;
      }
      return this;
    }
  }]);

  return MiniSignal;
})();

MiniSignal.MiniSignalBinding = MiniSignalBinding;

exports['default'] = MiniSignal;
module.exports = exports['default'];

},{}],2:[function(require,module,exports){
'use strict'

module.exports = function parseURI (str, opts) {
  opts = opts || {}

  var o = {
    key: ['source', 'protocol', 'authority', 'userInfo', 'user', 'password', 'host', 'port', 'relative', 'path', 'directory', 'file', 'query', 'anchor'],
    q: {
      name: 'queryKey',
      parser: /(?:^|&)([^&=]*)=?([^&]*)/g
    },
    parser: {
      strict: /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
      loose: /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/
    }
  }

  var m = o.parser[opts.strictMode ? 'strict' : 'loose'].exec(str)
  var uri = {}
  var i = 14

  while (i--) uri[o.key[i]] = m[i] || ''

  uri[o.q.name] = {}
  uri[o.key[12]].replace(o.q.parser, function ($0, $1, $2) {
    if ($1) uri[o.q.name][$1] = $2
  })

  return uri
}

},{}],3:[function(require,module,exports){
'use strict';

exports.__esModule = true;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _miniSignals = require('mini-signals');

var _miniSignals2 = _interopRequireDefault(_miniSignals);

var _parseUri = require('parse-uri');

var _parseUri2 = _interopRequireDefault(_parseUri);

var _async = require('./async');

var async = _interopRequireWildcard(_async);

var _Resource = require('./Resource');

var _Resource2 = _interopRequireDefault(_Resource);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// some constants
var MAX_PROGRESS = 100;
var rgxExtractUrlHash = /(#[\w\-]+)?$/;

/**
 * Manages the state and loading of multiple resources to load.
 *
 * @class
 */

var Loader = function () {
    /**
     * @param {string} [baseUrl=''] - The base url for all resources loaded by this loader.
     * @param {number} [concurrency=10] - The number of resources to load concurrently.
     */
    function Loader() {
        var _this = this;

        var baseUrl = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
        var concurrency = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 10;

        _classCallCheck(this, Loader);

        /**
         * The base url for all resources loaded by this loader.
         *
         * @member {string}
         */
        this.baseUrl = baseUrl;

        /**
         * The progress percent of the loader going through the queue.
         *
         * @member {number}
         */
        this.progress = 0;

        /**
         * Loading state of the loader, true if it is currently loading resources.
         *
         * @member {boolean}
         */
        this.loading = false;

        /**
         * A querystring to append to every URL added to the loader.
         *
         * This should be a valid query string *without* the question-mark (`?`). The loader will
         * also *not* escape values for you. Make sure to escape your parameters with
         * [`encodeURIComponent`](https://mdn.io/encodeURIComponent) before assigning this property.
         *
         * @example
         *
         * ```js
         * const loader = new Loader();
         *
         * loader.defaultQueryString = 'user=me&password=secret';
         *
         * // This will request 'image.png?user=me&password=secret'
         * loader.add('image.png').load();
         *
         * loader.reset();
         *
         * // This will request 'image.png?v=1&user=me&password=secret'
         * loader.add('iamge.png?v=1').load();
         * ```
         */
        this.defaultQueryString = '';

        /**
         * The middleware to run before loading each resource.
         *
         * @member {function[]}
         */
        this._beforeMiddleware = [];

        /**
         * The middleware to run after loading each resource.
         *
         * @member {function[]}
         */
        this._afterMiddleware = [];

        /**
         * The `_loadResource` function bound with this object context.
         *
         * @private
         * @member {function}
         * @param {Resource} r - The resource to load
         * @param {Function} d - The dequeue function
         * @return {undefined}
         */
        this._boundLoadResource = function (r, d) {
            return _this._loadResource(r, d);
        };

        /**
         * The resources waiting to be loaded.
         *
         * @private
         * @member {Resource[]}
         */
        this._queue = async.queue(this._boundLoadResource, concurrency);

        this._queue.pause();

        /**
         * All the resources for this loader keyed by name.
         *
         * @member {object<string, Resource>}
         */
        this.resources = {};

        /**
         * Dispatched once per loaded or errored resource.
         *
         * The callback looks like {@link Loader.OnProgressSignal}.
         *
         * @member {Signal}
         */
        this.onProgress = new _miniSignals2.default();

        /**
         * Dispatched once per errored resource.
         *
         * The callback looks like {@link Loader.OnErrorSignal}.
         *
         * @member {Signal}
         */
        this.onError = new _miniSignals2.default();

        /**
         * Dispatched once per loaded resource.
         *
         * The callback looks like {@link Loader.OnLoadSignal}.
         *
         * @member {Signal}
         */
        this.onLoad = new _miniSignals2.default();

        /**
         * Dispatched when the loader begins to process the queue.
         *
         * The callback looks like {@link Loader.OnStartSignal}.
         *
         * @member {Signal}
         */
        this.onStart = new _miniSignals2.default();

        /**
         * Dispatched when the queued resources all load.
         *
         * The callback looks like {@link Loader.OnCompleteSignal}.
         *
         * @member {Signal}
         */
        this.onComplete = new _miniSignals2.default();

        /**
         * When the progress changes the loader and resource are disaptched.
         *
         * @memberof Loader
         * @callback OnProgressSignal
         * @param {Loader} loader - The loader the progress is advancing on.
         * @param {Resource} resource - The resource that has completed or failed to cause the progress to advance.
         */

        /**
         * When an error occurrs the loader and resource are disaptched.
         *
         * @memberof Loader
         * @callback OnErrorSignal
         * @param {Loader} loader - The loader the error happened in.
         * @param {Resource} resource - The resource that caused the error.
         */

        /**
         * When a load completes the loader and resource are disaptched.
         *
         * @memberof Loader
         * @callback OnLoadSignal
         * @param {Loader} loader - The loader that laoded the resource.
         * @param {Resource} resource - The resource that has completed loading.
         */

        /**
         * When the loader starts loading resources it dispatches this callback.
         *
         * @memberof Loader
         * @callback OnStartSignal
         * @param {Loader} loader - The loader that has started loading resources.
         */

        /**
         * When the loader completes loading resources it dispatches this callback.
         *
         * @memberof Loader
         * @callback OnCompleteSignal
         * @param {Loader} loader - The loader that has finished loading resources.
         */
    }

    /**
     * Adds a resource (or multiple resources) to the loader queue.
     *
     * This function can take a wide variety of different parameters. The only thing that is always
     * required the url to load. All the following will work:
     *
     * ```js
     * loader
     *     // normal param syntax
     *     .add('key', 'http://...', function () {})
     *     .add('http://...', function () {})
     *     .add('http://...')
     *
     *     // object syntax
     *     .add({
     *         name: 'key2',
     *         url: 'http://...'
     *     }, function () {})
     *     .add({
     *         url: 'http://...'
     *     }, function () {})
     *     .add({
     *         name: 'key3',
     *         url: 'http://...'
     *         onComplete: function () {}
     *     })
     *     .add({
     *         url: 'https://...',
     *         onComplete: function () {},
     *         crossOrigin: true
     *     })
     *
     *     // you can also pass an array of objects or urls or both
     *     .add([
     *         { name: 'key4', url: 'http://...', onComplete: function () {} },
     *         { url: 'http://...', onComplete: function () {} },
     *         'http://...'
     *     ])
     *
     *     // and you can use both params and options
     *     .add('key', 'http://...', { crossOrigin: true }, function () {})
     *     .add('http://...', { crossOrigin: true }, function () {});
     * ```
     *
     * @param {string} [name] - The name of the resource to load, if not passed the url is used.
     * @param {string} [url] - The url for this resource, relative to the baseUrl of this loader.
     * @param {object} [options] - The options for the load.
     * @param {boolean} [options.crossOrigin] - Is this request cross-origin? Default is to determine automatically.
     * @param {Resource.LOAD_TYPE} [options.loadType=Resource.LOAD_TYPE.XHR] - How should this resource be loaded?
     * @param {Resource.XHR_RESPONSE_TYPE} [options.xhrType=Resource.XHR_RESPONSE_TYPE.DEFAULT] - How should
     *      the data being loaded be interpreted when using XHR?
     * @param {object} [options.metadata] - Extra configuration for middleware and the Resource object.
     * @param {HTMLImageElement|HTMLAudioElement|HTMLVideoElement} [options.metadata.loadElement=null] - The
     *      element to use for loading, instead of creating one.
     * @param {boolean} [options.metadata.skipSource=false] - Skips adding source(s) to the load element. This
     *      is useful if you want to pass in a `loadElement` that you already added load sources to.
     * @param {function} [cb] - Function to call when this specific resource completes loading.
     * @return {Loader} Returns itself.
     */


    Loader.prototype.add = function add(name, url, options, cb) {
        // special case of an array of objects or urls
        if (Array.isArray(name)) {
            for (var i = 0; i < name.length; ++i) {
                this.add(name[i]);
            }

            return this;
        }

        // if an object is passed instead of params
        if ((typeof name === 'undefined' ? 'undefined' : _typeof(name)) === 'object') {
            cb = url || name.callback || name.onComplete;
            options = name;
            url = name.url;
            name = name.name || name.key || name.url;
        }

        // case where no name is passed shift all args over by one.
        if (typeof url !== 'string') {
            cb = options;
            options = url;
            url = name;
        }

        // now that we shifted make sure we have a proper url.
        if (typeof url !== 'string') {
            throw new Error('No url passed to add resource to loader.');
        }

        // options are optional so people might pass a function and no options
        if (typeof options === 'function') {
            cb = options;
            options = null;
        }

        // if loading already you can only add resources that have a parent.
        if (this.loading && (!options || !options.parentResource)) {
            throw new Error('Cannot add resources while the loader is running.');
        }

        // check if resource already exists.
        if (this.resources[name]) {
            throw new Error('Resource named "' + name + '" already exists.');
        }

        // add base url if this isn't an absolute url
        url = this._prepareUrl(url);

        // create the store the resource
        this.resources[name] = new _Resource2.default(name, url, options);

        if (typeof cb === 'function') {
            this.resources[name].onAfterMiddleware.once(cb);
        }

        // if loading make sure to adjust progress chunks for that parent and its children
        if (this.loading) {
            var parent = options.parentResource;
            var fullChunk = parent.progressChunk * (parent.children.length + 1); // +1 for parent
            var eachChunk = fullChunk / (parent.children.length + 2); // +2 for parent & new child

            parent.children.push(this.resources[name]);
            parent.progressChunk = eachChunk;

            for (var _i = 0; _i < parent.children.length; ++_i) {
                parent.children[_i].progressChunk = eachChunk;
            }
        }

        // add the resource to the queue
        this._queue.push(this.resources[name]);

        return this;
    };

    /**
     * Sets up a middleware function that will run *before* the
     * resource is loaded.
     *
     * @method before
     * @param {function} fn - The middleware function to register.
     * @return {Loader} Returns itself.
     */


    Loader.prototype.pre = function pre(fn) {
        this._beforeMiddleware.push(fn);

        return this;
    };

    /**
     * Sets up a middleware function that will run *after* the
     * resource is loaded.
     *
     * @alias use
     * @method after
     * @param {function} fn - The middleware function to register.
     * @return {Loader} Returns itself.
     */


    Loader.prototype.use = function use(fn) {
        this._afterMiddleware.push(fn);

        return this;
    };

    /**
     * Resets the queue of the loader to prepare for a new load.
     *
     * @return {Loader} Returns itself.
     */


    Loader.prototype.reset = function reset() {
        this.progress = 0;
        this.loading = false;

        this._queue.kill();
        this._queue.pause();

        // abort all resource loads
        for (var k in this.resources) {
            var res = this.resources[k];

            if (res._onLoadBinding) {
                res._onLoadBinding.detach();
            }

            if (res.isLoading) {
                res.abort();
            }
        }

        this.resources = {};

        return this;
    };

    /**
     * Starts loading the queued resources.
     *
     * @param {function} [cb] - Optional callback that will be bound to the `complete` event.
     * @return {Loader} Returns itself.
     */


    Loader.prototype.load = function load(cb) {
        // register complete callback if they pass one
        if (typeof cb === 'function') {
            this.onComplete.once(cb);
        }

        // if the queue has already started we are done here
        if (this.loading) {
            return this;
        }

        // distribute progress chunks
        var chunk = 100 / this._queue._tasks.length;

        for (var i = 0; i < this._queue._tasks.length; ++i) {
            this._queue._tasks[i].data.progressChunk = chunk;
        }

        // update loading state
        this.loading = true;

        // notify of start
        this.onStart.dispatch(this);

        // start loading
        this._queue.resume();

        return this;
    };

    /**
     * Prepares a url for usage based on the configuration of this object
     *
     * @private
     * @param {string} url - The url to prepare.
     * @return {string} The prepared url.
     */


    Loader.prototype._prepareUrl = function _prepareUrl(url) {
        var parsedUrl = (0, _parseUri2.default)(url, { strictMode: true });
        var result = void 0;

        // absolute url, just use it as is.
        if (parsedUrl.protocol || !parsedUrl.path || url.indexOf('//') === 0) {
            result = url;
        }
        // if baseUrl doesn't end in slash and url doesn't start with slash, then add a slash inbetween
        else if (this.baseUrl.length && this.baseUrl.lastIndexOf('/') !== this.baseUrl.length - 1 && url.charAt(0) !== '/') {
                result = this.baseUrl + '/' + url;
            } else {
                result = this.baseUrl + url;
            }

        // if we need to add a default querystring, there is a bit more work
        if (this.defaultQueryString) {
            var hash = rgxExtractUrlHash.exec(result)[0];

            result = result.substr(0, result.length - hash.length);

            if (result.indexOf('?') !== -1) {
                result += '&' + this.defaultQueryString;
            } else {
                result += '?' + this.defaultQueryString;
            }

            result += hash;
        }

        return result;
    };

    /**
     * Loads a single resource.
     *
     * @private
     * @param {Resource} resource - The resource to load.
     * @param {function} dequeue - The function to call when we need to dequeue this item.
     */


    Loader.prototype._loadResource = function _loadResource(resource, dequeue) {
        var _this2 = this;

        resource._dequeue = dequeue;

        // run before middleware
        async.eachSeries(this._beforeMiddleware, function (fn, next) {
            fn.call(_this2, resource, function () {
                // if the before middleware marks the resource as complete,
                // break and don't process any more before middleware
                next(resource.isComplete ? {} : null);
            });
        }, function () {
            if (resource.isComplete) {
                _this2._onLoad(resource);
            } else {
                resource._onLoadBinding = resource.onComplete.once(_this2._onLoad, _this2);
                resource.load();
            }
        });
    };

    /**
     * Called once each resource has loaded.
     *
     * @private
     */


    Loader.prototype._onComplete = function _onComplete() {
        this.loading = false;

        this.onComplete.dispatch(this, this.resources);
    };

    /**
     * Called each time a resources is loaded.
     *
     * @private
     * @param {Resource} resource - The resource that was loaded
     */


    Loader.prototype._onLoad = function _onLoad(resource) {
        var _this3 = this;

        resource._onLoadBinding = null;

        // run middleware, this *must* happen before dequeue so sub-assets get added properly
        async.eachSeries(this._afterMiddleware, function (fn, next) {
            fn.call(_this3, resource, next);
        }, function () {
            resource.onAfterMiddleware.dispatch(resource);

            _this3.progress += resource.progressChunk;
            _this3.onProgress.dispatch(_this3, resource);

            if (resource.error) {
                _this3.onError.dispatch(resource.error, _this3, resource);
            } else {
                _this3.onLoad.dispatch(_this3, resource);
            }

            // remove this resource from the async queue
            resource._dequeue();

            // do completion check
            if (_this3._queue.idle()) {
                _this3.progress = MAX_PROGRESS;
                _this3._onComplete();
            }
        });
    };

    return Loader;
}();

exports.default = Loader;

},{"./Resource":4,"./async":5,"mini-signals":1,"parse-uri":2}],4:[function(require,module,exports){
'use strict';

exports.__esModule = true;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _parseUri = require('parse-uri');

var _parseUri2 = _interopRequireDefault(_parseUri);

var _miniSignals = require('mini-signals');

var _miniSignals2 = _interopRequireDefault(_miniSignals);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// tests is CORS is supported in XHR, if not we need to use XDR
var useXdr = !!(window.XDomainRequest && !('withCredentials' in new XMLHttpRequest()));
var tempAnchor = null;

// some status constants
var STATUS_NONE = 0;
var STATUS_OK = 200;
var STATUS_EMPTY = 204;

// noop
function _noop() {} /* empty */

/**
 * Manages the state and loading of a resource and all child resources.
 *
 * @class
 */

var Resource = function () {
    /**
     * Sets the load type to be used for a specific extension.
     *
     * @static
     * @param {string} extname - The extension to set the type for, e.g. "png" or "fnt"
     * @param {Resource.LOAD_TYPE} loadType - The load type to set it to.
     */
    Resource.setExtensionLoadType = function setExtensionLoadType(extname, loadType) {
        setExtMap(Resource._loadTypeMap, extname, loadType);
    };

    /**
     * Sets the load type to be used for a specific extension.
     *
     * @static
     * @param {string} extname - The extension to set the type for, e.g. "png" or "fnt"
     * @param {Resource.XHR_RESPONSE_TYPE} xhrType - The xhr type to set it to.
     */


    Resource.setExtensionXhrType = function setExtensionXhrType(extname, xhrType) {
        setExtMap(Resource._xhrTypeMap, extname, xhrType);
    };

    /**
     * @param {string} name - The name of the resource to load.
     * @param {string|string[]} url - The url for this resource, for audio/video loads you can pass
     *      an array of sources.
     * @param {object} [options] - The options for the load.
     * @param {string|boolean} [options.crossOrigin] - Is this request cross-origin? Default is to
     *      determine automatically.
     * @param {Resource.LOAD_TYPE} [options.loadType=Resource.LOAD_TYPE.XHR] - How should this resource
     *      be loaded?
     * @param {Resource.XHR_RESPONSE_TYPE} [options.xhrType=Resource.XHR_RESPONSE_TYPE.DEFAULT] - How
     *      should the data being loaded be interpreted when using XHR?
     * @param {object} [options.metadata] - Extra configuration for middleware and the Resource object.
     * @param {HTMLImageElement|HTMLAudioElement|HTMLVideoElement} [options.metadata.loadElement=null] - The
     *      element to use for loading, instead of creating one.
     * @param {boolean} [options.metadata.skipSource=false] - Skips adding source(s) to the load element. This
     *      is useful if you want to pass in a `loadElement` that you already added load sources to.
     */


    function Resource(name, url, options) {
        _classCallCheck(this, Resource);

        if (typeof name !== 'string' || typeof url !== 'string') {
            throw new Error('Both name and url are required for constructing a resource.');
        }

        options = options || {};

        /**
         * The state flags of this resource.
         *
         * @member {number}
         */
        this._flags = 0;

        // set data url flag, needs to be set early for some _determineX checks to work.
        this._setFlag(Resource.STATUS_FLAGS.DATA_URL, url.indexOf('data:') === 0);

        /**
         * The name of this resource.
         *
         * @member {string}
         * @readonly
         */
        this.name = name;

        /**
         * The url used to load this resource.
         *
         * @member {string}
         * @readonly
         */
        this.url = url;

        /**
         * The data that was loaded by the resource.
         *
         * @member {any}
         */
        this.data = null;

        /**
         * Is this request cross-origin? If unset, determined automatically.
         *
         * @member {string}
         */
        this.crossOrigin = options.crossOrigin === true ? 'anonymous' : options.crossOrigin;

        /**
         * The method of loading to use for this resource.
         *
         * @member {Resource.LOAD_TYPE}
         */
        this.loadType = options.loadType || this._determineLoadType();

        /**
         * The type used to load the resource via XHR. If unset, determined automatically.
         *
         * @member {string}
         */
        this.xhrType = options.xhrType;

        /**
         * Extra info for middleware, and controlling specifics about how the resource loads.
         *
         * Note that if you pass in a `loadElement`, the Resource class takes ownership of it.
         * Meaning it will modify it as it sees fit.
         *
         * @member {object}
         * @property {HTMLImageElement|HTMLAudioElement|HTMLVideoElement} [loadElement=null] - The
         *  element to use for loading, instead of creating one.
         * @property {boolean} [skipSource=false] - Skips adding source(s) to the load element. This
         *  is useful if you want to pass in a `loadElement` that you already added load sources
         *  to.
         */
        this.metadata = options.metadata || {};

        /**
         * The error that occurred while loading (if any).
         *
         * @member {Error}
         * @readonly
         */
        this.error = null;

        /**
         * The XHR object that was used to load this resource. This is only set
         * when `loadType` is `Resource.LOAD_TYPE.XHR`.
         *
         * @member {XMLHttpRequest}
         * @readonly
         */
        this.xhr = null;

        /**
         * The child resources this resource owns.
         *
         * @member {Resource[]}
         * @readonly
         */
        this.children = [];

        /**
         * The resource type.
         *
         * @member {Resource.TYPE}
         * @readonly
         */
        this.type = Resource.TYPE.UNKNOWN;

        /**
         * The progress chunk owned by this resource.
         *
         * @member {number}
         * @readonly
         */
        this.progressChunk = 0;

        /**
         * The `dequeue` method that will be used a storage place for the async queue dequeue method
         * used privately by the loader.
         *
         * @private
         * @member {function}
         */
        this._dequeue = _noop;

        /**
         * Used a storage place for the on load binding used privately by the loader.
         *
         * @private
         * @member {function}
         */
        this._onLoadBinding = null;

        /**
         * The `complete` function bound to this resource's context.
         *
         * @private
         * @member {function}
         */
        this._boundComplete = this.complete.bind(this);

        /**
         * The `_onError` function bound to this resource's context.
         *
         * @private
         * @member {function}
         */
        this._boundOnError = this._onError.bind(this);

        /**
         * The `_onProgress` function bound to this resource's context.
         *
         * @private
         * @member {function}
         */
        this._boundOnProgress = this._onProgress.bind(this);

        // xhr callbacks
        this._boundXhrOnError = this._xhrOnError.bind(this);
        this._boundXhrOnAbort = this._xhrOnAbort.bind(this);
        this._boundXhrOnLoad = this._xhrOnLoad.bind(this);
        this._boundXdrOnTimeout = this._xdrOnTimeout.bind(this);

        /**
         * Dispatched when the resource beings to load.
         *
         * The callback looks like {@link Resource.OnStartSignal}.
         *
         * @member {Signal}
         */
        this.onStart = new _miniSignals2.default();

        /**
         * Dispatched each time progress of this resource load updates.
         * Not all resources types and loader systems can support this event
         * so sometimes it may not be available. If the resource
         * is being loaded on a modern browser, using XHR, and the remote server
         * properly sets Content-Length headers, then this will be available.
         *
         * The callback looks like {@link Resource.OnProgressSignal}.
         *
         * @member {Signal}
         */
        this.onProgress = new _miniSignals2.default();

        /**
         * Dispatched once this resource has loaded, if there was an error it will
         * be in the `error` property.
         *
         * The callback looks like {@link Resource.OnCompleteSignal}.
         *
         * @member {Signal}
         */
        this.onComplete = new _miniSignals2.default();

        /**
         * Dispatched after this resource has had all the *after* middleware run on it.
         *
         * The callback looks like {@link Resource.OnCompleteSignal}.
         *
         * @member {Signal}
         */
        this.onAfterMiddleware = new _miniSignals2.default();

        /**
         * When the resource starts to load.
         *
         * @memberof Resource
         * @callback OnStartSignal
         * @param {Resource} resource - The resource that the event happened on.
         */

        /**
         * When the resource reports loading progress.
         *
         * @memberof Resource
         * @callback OnProgressSignal
         * @param {Resource} resource - The resource that the event happened on.
         * @param {number} percentage - The progress of the load in the range [0, 1].
         */

        /**
         * When the resource finishes loading.
         *
         * @memberof Resource
         * @callback OnCompleteSignal
         * @param {Resource} resource - The resource that the event happened on.
         */
    }

    /**
     * Stores whether or not this url is a data url.
     *
     * @member {boolean}
     * @readonly
     */


    /**
     * Marks the resource as complete.
     *
     */
    Resource.prototype.complete = function complete() {
        // TODO: Clean this up in a wrapper or something...gross....
        if (this.data && this.data.removeEventListener) {
            this.data.removeEventListener('error', this._boundOnError, false);
            this.data.removeEventListener('load', this._boundComplete, false);
            this.data.removeEventListener('progress', this._boundOnProgress, false);
            this.data.removeEventListener('canplaythrough', this._boundComplete, false);
        }

        if (this.xhr) {
            if (this.xhr.removeEventListener) {
                this.xhr.removeEventListener('error', this._boundXhrOnError, false);
                this.xhr.removeEventListener('abort', this._boundXhrOnAbort, false);
                this.xhr.removeEventListener('progress', this._boundOnProgress, false);
                this.xhr.removeEventListener('load', this._boundXhrOnLoad, false);
            } else {
                this.xhr.onerror = null;
                this.xhr.ontimeout = null;
                this.xhr.onprogress = null;
                this.xhr.onload = null;
            }
        }

        if (this.isComplete) {
            throw new Error('Complete called again for an already completed resource.');
        }

        this._setFlag(Resource.STATUS_FLAGS.COMPLETE, true);
        this._setFlag(Resource.STATUS_FLAGS.LOADING, false);

        this.onComplete.dispatch(this);
    };

    /**
     * Aborts the loading of this resource, with an optional message.
     *
     * @param {string} message - The message to use for the error
     */


    Resource.prototype.abort = function abort(message) {
        // abort can be called multiple times, ignore subsequent calls.
        if (this.error) {
            return;
        }

        // store error
        this.error = new Error(message);

        // abort the actual loading
        if (this.xhr) {
            this.xhr.abort();
        } else if (this.xdr) {
            this.xdr.abort();
        } else if (this.data) {
            // single source
            if (this.data.src) {
                this.data.src = Resource.EMPTY_GIF;
            }
            // multi-source
            else {
                    while (this.data.firstChild) {
                        this.data.removeChild(this.data.firstChild);
                    }
                }
        }

        // done now.
        this.complete();
    };

    /**
     * Kicks off loading of this resource. This method is asynchronous.
     *
     * @param {function} [cb] - Optional callback to call once the resource is loaded.
     */


    Resource.prototype.load = function load(cb) {
        var _this = this;

        if (this.isLoading) {
            return;
        }

        if (this.isComplete) {
            if (cb) {
                setTimeout(function () {
                    return cb(_this);
                }, 1);
            }

            return;
        } else if (cb) {
            this.onComplete.once(cb);
        }

        this._setFlag(Resource.STATUS_FLAGS.LOADING, true);

        this.onStart.dispatch(this);

        // if unset, determine the value
        if (this.crossOrigin === false || typeof this.crossOrigin !== 'string') {
            this.crossOrigin = this._determineCrossOrigin(this.url);
        }

        switch (this.loadType) {
            case Resource.LOAD_TYPE.IMAGE:
                this.type = Resource.TYPE.IMAGE;
                this._loadElement('image');
                break;

            case Resource.LOAD_TYPE.AUDIO:
                this.type = Resource.TYPE.AUDIO;
                this._loadSourceElement('audio');
                break;

            case Resource.LOAD_TYPE.VIDEO:
                this.type = Resource.TYPE.VIDEO;
                this._loadSourceElement('video');
                break;

            case Resource.LOAD_TYPE.XHR:
            /* falls through */
            default:
                if (useXdr && this.crossOrigin) {
                    this._loadXdr();
                } else {
                    this._loadXhr();
                }
                break;
        }
    };

    /**
     * Checks if the flag is set.
     *
     * @private
     * @param {number} flag - The flag to check.
     * @return {boolean} True if the flag is set.
     */


    Resource.prototype._hasFlag = function _hasFlag(flag) {
        return !!(this._flags & flag);
    };

    /**
     * (Un)Sets the flag.
     *
     * @private
     * @param {number} flag - The flag to (un)set.
     * @param {boolean} value - Whether to set or (un)set the flag.
     */


    Resource.prototype._setFlag = function _setFlag(flag, value) {
        this._flags = value ? this._flags | flag : this._flags & ~flag;
    };

    /**
     * Loads this resources using an element that has a single source,
     * like an HTMLImageElement.
     *
     * @private
     * @param {string} type - The type of element to use.
     */


    Resource.prototype._loadElement = function _loadElement(type) {
        if (this.metadata.loadElement) {
            this.data = this.metadata.loadElement;
        } else if (type === 'image' && typeof window.Image !== 'undefined') {
            this.data = new Image();
        } else {
            this.data = document.createElement(type);
        }

        if (this.crossOrigin) {
            this.data.crossOrigin = this.crossOrigin;
        }

        if (!this.metadata.skipSource) {
            this.data.src = this.url;
        }

        this.data.addEventListener('error', this._boundOnError, false);
        this.data.addEventListener('load', this._boundComplete, false);
        this.data.addEventListener('progress', this._boundOnProgress, false);
    };

    /**
     * Loads this resources using an element that has multiple sources,
     * like an HTMLAudioElement or HTMLVideoElement.
     *
     * @private
     * @param {string} type - The type of element to use.
     */


    Resource.prototype._loadSourceElement = function _loadSourceElement(type) {
        if (this.metadata.loadElement) {
            this.data = this.metadata.loadElement;
        } else if (type === 'audio' && typeof window.Audio !== 'undefined') {
            this.data = new Audio();
        } else {
            this.data = document.createElement(type);
        }

        if (this.data === null) {
            this.abort('Unsupported element: ' + type);

            return;
        }

        if (!this.metadata.skipSource) {
            // support for CocoonJS Canvas+ runtime, lacks document.createElement('source')
            if (navigator.isCocoonJS) {
                this.data.src = Array.isArray(this.url) ? this.url[0] : this.url;
            } else if (Array.isArray(this.url)) {
                for (var i = 0; i < this.url.length; ++i) {
                    this.data.appendChild(this._createSource(type, this.url[i]));
                }
            } else {
                this.data.appendChild(this._createSource(type, this.url));
            }
        }

        this.data.addEventListener('error', this._boundOnError, false);
        this.data.addEventListener('load', this._boundComplete, false);
        this.data.addEventListener('progress', this._boundOnProgress, false);
        this.data.addEventListener('canplaythrough', this._boundComplete, false);

        this.data.load();
    };

    /**
     * Loads this resources using an XMLHttpRequest.
     *
     * @private
     */


    Resource.prototype._loadXhr = function _loadXhr() {
        // if unset, determine the value
        if (typeof this.xhrType !== 'string') {
            this.xhrType = this._determineXhrType();
        }

        var xhr = this.xhr = new XMLHttpRequest();

        // set the request type and url
        xhr.open('GET', this.url, true);

        // load json as text and parse it ourselves. We do this because some browsers
        // *cough* safari *cough* can't deal with it.
        if (this.xhrType === Resource.XHR_RESPONSE_TYPE.JSON || this.xhrType === Resource.XHR_RESPONSE_TYPE.DOCUMENT) {
            xhr.responseType = Resource.XHR_RESPONSE_TYPE.TEXT;
        } else {
            xhr.responseType = this.xhrType;
        }

        xhr.addEventListener('error', this._boundXhrOnError, false);
        xhr.addEventListener('abort', this._boundXhrOnAbort, false);
        xhr.addEventListener('progress', this._boundOnProgress, false);
        xhr.addEventListener('load', this._boundXhrOnLoad, false);

        xhr.send();
    };

    /**
     * Loads this resources using an XDomainRequest. This is here because we need to support IE9 (gross).
     *
     * @private
     */


    Resource.prototype._loadXdr = function _loadXdr() {
        // if unset, determine the value
        if (typeof this.xhrType !== 'string') {
            this.xhrType = this._determineXhrType();
        }

        var xdr = this.xhr = new XDomainRequest();

        // XDomainRequest has a few quirks. Occasionally it will abort requests
        // A way to avoid this is to make sure ALL callbacks are set even if not used
        // More info here: http://stackoverflow.com/questions/15786966/xdomainrequest-aborts-post-on-ie-9
        xdr.timeout = 5000;

        xdr.onerror = this._boundXhrOnError;
        xdr.ontimeout = this._boundXdrOnTimeout;
        xdr.onprogress = this._boundOnProgress;
        xdr.onload = this._boundXhrOnLoad;

        xdr.open('GET', this.url, true);

        // Note: The xdr.send() call is wrapped in a timeout to prevent an
        // issue with the interface where some requests are lost if multiple
        // XDomainRequests are being sent at the same time.
        // Some info here: https://github.com/photonstorm/phaser/issues/1248
        setTimeout(function () {
            return xdr.send();
        }, 1);
    };

    /**
     * Creates a source used in loading via an element.
     *
     * @private
     * @param {string} type - The element type (video or audio).
     * @param {string} url - The source URL to load from.
     * @param {string} [mime] - The mime type of the video
     * @return {HTMLSourceElement} The source element.
     */


    Resource.prototype._createSource = function _createSource(type, url, mime) {
        if (!mime) {
            mime = type + '/' + url.substr(url.lastIndexOf('.') + 1);
        }

        var source = document.createElement('source');

        source.src = url;
        source.type = mime;

        return source;
    };

    /**
     * Called if a load errors out.
     *
     * @param {Event} event - The error event from the element that emits it.
     * @private
     */


    Resource.prototype._onError = function _onError(event) {
        this.abort('Failed to load element using: ' + event.target.nodeName);
    };

    /**
     * Called if a load progress event fires for xhr/xdr.
     *
     * @private
     * @param {XMLHttpRequestProgressEvent|Event} event - Progress event.
     */


    Resource.prototype._onProgress = function _onProgress(event) {
        if (event && event.lengthComputable) {
            this.onProgress.dispatch(this, event.loaded / event.total);
        }
    };

    /**
     * Called if an error event fires for xhr/xdr.
     *
     * @private
     * @param {XMLHttpRequestErrorEvent|Event} event - Error event.
     */


    Resource.prototype._xhrOnError = function _xhrOnError() {
        var xhr = this.xhr;

        this.abort(reqType(xhr) + ' Request failed. Status: ' + xhr.status + ', text: "' + xhr.statusText + '"');
    };

    /**
     * Called if an abort event fires for xhr.
     *
     * @private
     * @param {XMLHttpRequestAbortEvent} event - Abort Event
     */


    Resource.prototype._xhrOnAbort = function _xhrOnAbort() {
        this.abort(reqType(this.xhr) + ' Request was aborted by the user.');
    };

    /**
     * Called if a timeout event fires for xdr.
     *
     * @private
     * @param {Event} event - Timeout event.
     */


    Resource.prototype._xdrOnTimeout = function _xdrOnTimeout() {
        this.abort(reqType(this.xhr) + ' Request timed out.');
    };

    /**
     * Called when data successfully loads from an xhr/xdr request.
     *
     * @private
     * @param {XMLHttpRequestLoadEvent|Event} event - Load event
     */


    Resource.prototype._xhrOnLoad = function _xhrOnLoad() {
        var xhr = this.xhr;
        var status = typeof xhr.status === 'undefined' ? xhr.status : STATUS_OK; // XDR has no `.status`, assume 200.

        // status can be 0 when using the `file://` protocol so we also check if a response is set
        if (status === STATUS_OK || status === STATUS_EMPTY || status === STATUS_NONE && xhr.responseText.length > 0) {
            // if text, just return it
            if (this.xhrType === Resource.XHR_RESPONSE_TYPE.TEXT) {
                this.data = xhr.responseText;
                this.type = Resource.TYPE.TEXT;
            }
            // if json, parse into json object
            else if (this.xhrType === Resource.XHR_RESPONSE_TYPE.JSON) {
                    try {
                        this.data = JSON.parse(xhr.responseText);
                        this.type = Resource.TYPE.JSON;
                    } catch (e) {
                        this.abort('Error trying to parse loaded json: ' + e);

                        return;
                    }
                }
                // if xml, parse into an xml document or div element
                else if (this.xhrType === Resource.XHR_RESPONSE_TYPE.DOCUMENT) {
                        try {
                            if (window.DOMParser) {
                                var domparser = new DOMParser();

                                this.data = domparser.parseFromString(xhr.responseText, 'text/xml');
                            } else {
                                var div = document.createElement('div');

                                div.innerHTML = xhr.responseText;

                                this.data = div;
                            }

                            this.type = Resource.TYPE.XML;
                        } catch (e) {
                            this.abort('Error trying to parse loaded xml: ' + e);

                            return;
                        }
                    }
                    // other types just return the response
                    else {
                            this.data = xhr.response || xhr.responseText;
                        }
        } else {
            this.abort('[' + xhr.status + '] ' + xhr.statusText + ': ' + xhr.responseURL);

            return;
        }

        this.complete();
    };

    /**
     * Sets the `crossOrigin` property for this resource based on if the url
     * for this resource is cross-origin. If crossOrigin was manually set, this
     * function does nothing.
     *
     * @private
     * @param {string} url - The url to test.
     * @param {object} [loc=window.location] - The location object to test against.
     * @return {string} The crossOrigin value to use (or empty string for none).
     */


    Resource.prototype._determineCrossOrigin = function _determineCrossOrigin(url, loc) {
        // data: and javascript: urls are considered same-origin
        if (url.indexOf('data:') === 0) {
            return '';
        }

        // default is window.location
        loc = loc || window.location;

        if (!tempAnchor) {
            tempAnchor = document.createElement('a');
        }

        // let the browser determine the full href for the url of this resource and then
        // parse with the node url lib, we can't use the properties of the anchor element
        // because they don't work in IE9 :(
        tempAnchor.href = url;
        url = (0, _parseUri2.default)(tempAnchor.href, { strictMode: true });

        var samePort = !url.port && loc.port === '' || url.port === loc.port;
        var protocol = url.protocol ? url.protocol + ':' : '';

        // if cross origin
        if (url.host !== loc.hostname || !samePort || protocol !== loc.protocol) {
            return 'anonymous';
        }

        return '';
    };

    /**
     * Determines the responseType of an XHR request based on the extension of the
     * resource being loaded.
     *
     * @private
     * @return {Resource.XHR_RESPONSE_TYPE} The responseType to use.
     */


    Resource.prototype._determineXhrType = function _determineXhrType() {
        return Resource._xhrTypeMap[this._getExtension()] || Resource.XHR_RESPONSE_TYPE.TEXT;
    };

    /**
     * Determines the loadType of a resource based on the extension of the
     * resource being loaded.
     *
     * @private
     * @return {Resource.LOAD_TYPE} The loadType to use.
     */


    Resource.prototype._determineLoadType = function _determineLoadType() {
        return Resource._loadTypeMap[this._getExtension()] || Resource.LOAD_TYPE.XHR;
    };

    /**
     * Extracts the extension (sans '.') of the file being loaded by the resource.
     *
     * @private
     * @return {string} The extension.
     */


    Resource.prototype._getExtension = function _getExtension() {
        var url = this.url;
        var ext = '';

        if (this.isDataUrl) {
            var slashIndex = url.indexOf('/');

            ext = url.substring(slashIndex + 1, url.indexOf(';', slashIndex));
        } else {
            var queryStart = url.indexOf('?');

            if (queryStart !== -1) {
                url = url.substring(0, queryStart);
            }

            ext = url.substring(url.lastIndexOf('.') + 1);
        }

        return ext.toLowerCase();
    };

    /**
     * Determines the mime type of an XHR request based on the responseType of
     * resource being loaded.
     *
     * @private
     * @param {Resource.XHR_RESPONSE_TYPE} type - The type to get a mime type for.
     * @return {string} The mime type to use.
     */


    Resource.prototype._getMimeFromXhrType = function _getMimeFromXhrType(type) {
        switch (type) {
            case Resource.XHR_RESPONSE_TYPE.BUFFER:
                return 'application/octet-binary';

            case Resource.XHR_RESPONSE_TYPE.BLOB:
                return 'application/blob';

            case Resource.XHR_RESPONSE_TYPE.DOCUMENT:
                return 'application/xml';

            case Resource.XHR_RESPONSE_TYPE.JSON:
                return 'application/json';

            case Resource.XHR_RESPONSE_TYPE.DEFAULT:
            case Resource.XHR_RESPONSE_TYPE.TEXT:
            /* falls through */
            default:
                return 'text/plain';

        }
    };

    _createClass(Resource, [{
        key: 'isDataUrl',
        get: function get() {
            return this._hasFlag(Resource.STATUS_FLAGS.DATA_URL);
        }

        /**
         * Describes if this resource has finished loading. Is true when the resource has completely
         * loaded.
         *
         * @member {boolean}
         * @readonly
         */

    }, {
        key: 'isComplete',
        get: function get() {
            return this._hasFlag(Resource.STATUS_FLAGS.COMPLETE);
        }

        /**
         * Describes if this resource is currently loading. Is true when the resource starts loading,
         * and is false again when complete.
         *
         * @member {boolean}
         * @readonly
         */

    }, {
        key: 'isLoading',
        get: function get() {
            return this._hasFlag(Resource.STATUS_FLAGS.LOADING);
        }
    }]);

    return Resource;
}();

/**
 * The types of resources a resource could represent.
 *
 * @static
 * @readonly
 * @enum {number}
 */


exports.default = Resource;
Resource.STATUS_FLAGS = {
    NONE: 0,
    DATA_URL: 1 << 0,
    COMPLETE: 1 << 1,
    LOADING: 1 << 2
};

/**
 * The types of resources a resource could represent.
 *
 * @static
 * @readonly
 * @enum {number}
 */
Resource.TYPE = {
    UNKNOWN: 0,
    JSON: 1,
    XML: 2,
    IMAGE: 3,
    AUDIO: 4,
    VIDEO: 5,
    TEXT: 6
};

/**
 * The types of loading a resource can use.
 *
 * @static
 * @readonly
 * @enum {number}
 */
Resource.LOAD_TYPE = {
    /** Uses XMLHttpRequest to load the resource. */
    XHR: 1,
    /** Uses an `Image` object to load the resource. */
    IMAGE: 2,
    /** Uses an `Audio` object to load the resource. */
    AUDIO: 3,
    /** Uses a `Video` object to load the resource. */
    VIDEO: 4
};

/**
 * The XHR ready states, used internally.
 *
 * @static
 * @readonly
 * @enum {string}
 */
Resource.XHR_RESPONSE_TYPE = {
    /** string */
    DEFAULT: 'text',
    /** ArrayBuffer */
    BUFFER: 'arraybuffer',
    /** Blob */
    BLOB: 'blob',
    /** Document */
    DOCUMENT: 'document',
    /** Object */
    JSON: 'json',
    /** String */
    TEXT: 'text'
};

Resource._loadTypeMap = {
    // images
    gif: Resource.LOAD_TYPE.IMAGE,
    png: Resource.LOAD_TYPE.IMAGE,
    bmp: Resource.LOAD_TYPE.IMAGE,
    jpg: Resource.LOAD_TYPE.IMAGE,
    jpeg: Resource.LOAD_TYPE.IMAGE,
    tif: Resource.LOAD_TYPE.IMAGE,
    tiff: Resource.LOAD_TYPE.IMAGE,
    webp: Resource.LOAD_TYPE.IMAGE,
    tga: Resource.LOAD_TYPE.IMAGE,
    svg: Resource.LOAD_TYPE.IMAGE,
    'svg+xml': Resource.LOAD_TYPE.IMAGE, // for SVG data urls

    // audio
    mp3: Resource.LOAD_TYPE.AUDIO,
    ogg: Resource.LOAD_TYPE.AUDIO,
    wav: Resource.LOAD_TYPE.AUDIO,

    // videos
    mp4: Resource.LOAD_TYPE.VIDEO,
    webm: Resource.LOAD_TYPE.VIDEO
};

Resource._xhrTypeMap = {
    // xml
    xhtml: Resource.XHR_RESPONSE_TYPE.DOCUMENT,
    html: Resource.XHR_RESPONSE_TYPE.DOCUMENT,
    htm: Resource.XHR_RESPONSE_TYPE.DOCUMENT,
    xml: Resource.XHR_RESPONSE_TYPE.DOCUMENT,
    tmx: Resource.XHR_RESPONSE_TYPE.DOCUMENT,
    svg: Resource.XHR_RESPONSE_TYPE.DOCUMENT,

    // This was added to handle Tiled Tileset XML, but .tsx is also a TypeScript React Component.
    // Since it is way less likely for people to be loading TypeScript files instead of Tiled files,
    // this should probably be fine.
    tsx: Resource.XHR_RESPONSE_TYPE.DOCUMENT,

    // images
    gif: Resource.XHR_RESPONSE_TYPE.BLOB,
    png: Resource.XHR_RESPONSE_TYPE.BLOB,
    bmp: Resource.XHR_RESPONSE_TYPE.BLOB,
    jpg: Resource.XHR_RESPONSE_TYPE.BLOB,
    jpeg: Resource.XHR_RESPONSE_TYPE.BLOB,
    tif: Resource.XHR_RESPONSE_TYPE.BLOB,
    tiff: Resource.XHR_RESPONSE_TYPE.BLOB,
    webp: Resource.XHR_RESPONSE_TYPE.BLOB,
    tga: Resource.XHR_RESPONSE_TYPE.BLOB,

    // json
    json: Resource.XHR_RESPONSE_TYPE.JSON,

    // text
    text: Resource.XHR_RESPONSE_TYPE.TEXT,
    txt: Resource.XHR_RESPONSE_TYPE.TEXT,

    // fonts
    ttf: Resource.XHR_RESPONSE_TYPE.BUFFER,
    otf: Resource.XHR_RESPONSE_TYPE.BUFFER
};

// We can't set the `src` attribute to empty string, so on abort we set it to this 1px transparent gif
Resource.EMPTY_GIF = 'data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==';

/**
 * Quick helper to set a value on one of the extension maps. Ensures there is no
 * dot at the start of the extension.
 *
 * @ignore
 * @param {object} map - The map to set on.
 * @param {string} extname - The extension (or key) to set.
 * @param {number} val - The value to set.
 */
function setExtMap(map, extname, val) {
    if (extname && extname.indexOf('.') === 0) {
        extname = extname.substring(1);
    }

    if (!extname) {
        return;
    }

    map[extname] = val;
}

/**
 * Quick helper to get string xhr type.
 *
 * @ignore
 * @param {XMLHttpRequest|XDomainRequest} xhr - The request to check.
 * @return {string} The type.
 */
function reqType(xhr) {
    return xhr.toString().replace('object ', '');
}

},{"mini-signals":1,"parse-uri":2}],5:[function(require,module,exports){
'use strict';

exports.__esModule = true;
exports.eachSeries = eachSeries;
exports.queue = queue;
/**
 * Smaller version of the async library constructs.
 *
 */
function _noop() {} /* empty */

/**
 * Iterates an array in series.
 *
 * @param {*[]} array - Array to iterate.
 * @param {function} iterator - Function to call for each element.
 * @param {function} callback - Function to call when done, or on error.
 */
function eachSeries(array, iterator, callback) {
    var i = 0;
    var len = array.length;

    (function next(err) {
        if (err || i === len) {
            if (callback) {
                callback(err);
            }

            return;
        }

        iterator(array[i++], next);
    })();
}

/**
 * Ensures a function is only called once.
 *
 * @param {function} fn - The function to wrap.
 * @return {function} The wrapping function.
 */
function onlyOnce(fn) {
    return function onceWrapper() {
        if (fn === null) {
            throw new Error('Callback was already called.');
        }

        var callFn = fn;

        fn = null;
        callFn.apply(this, arguments);
    };
}

/**
 * Async queue implementation,
 *
 * @param {function} worker - The worker function to call for each task.
 * @param {number} concurrency - How many workers to run in parrallel.
 * @return {*} The async queue object.
 */
function queue(worker, concurrency) {
    if (concurrency == null) {
        // eslint-disable-line no-eq-null,eqeqeq
        concurrency = 1;
    } else if (concurrency === 0) {
        throw new Error('Concurrency must not be zero');
    }

    var workers = 0;
    var q = {
        _tasks: [],
        concurrency: concurrency,
        saturated: _noop,
        unsaturated: _noop,
        buffer: concurrency / 4,
        empty: _noop,
        drain: _noop,
        error: _noop,
        started: false,
        paused: false,
        push: function push(data, callback) {
            _insert(data, false, callback);
        },
        kill: function kill() {
            workers = 0;
            q.drain = _noop;
            q.started = false;
            q._tasks = [];
        },
        unshift: function unshift(data, callback) {
            _insert(data, true, callback);
        },
        process: function process() {
            while (!q.paused && workers < q.concurrency && q._tasks.length) {
                var task = q._tasks.shift();

                if (q._tasks.length === 0) {
                    q.empty();
                }

                workers += 1;

                if (workers === q.concurrency) {
                    q.saturated();
                }

                worker(task.data, onlyOnce(_next(task)));
            }
        },
        length: function length() {
            return q._tasks.length;
        },
        running: function running() {
            return workers;
        },
        idle: function idle() {
            return q._tasks.length + workers === 0;
        },
        pause: function pause() {
            if (q.paused === true) {
                return;
            }

            q.paused = true;
        },
        resume: function resume() {
            if (q.paused === false) {
                return;
            }

            q.paused = false;

            // Need to call q.process once per concurrent
            // worker to preserve full concurrency after pause
            for (var w = 1; w <= q.concurrency; w++) {
                q.process();
            }
        }
    };

    function _insert(data, insertAtFront, callback) {
        if (callback != null && typeof callback !== 'function') {
            // eslint-disable-line no-eq-null,eqeqeq
            throw new Error('task callback must be a function');
        }

        q.started = true;

        if (data == null && q.idle()) {
            // eslint-disable-line no-eq-null,eqeqeq
            // call drain immediately if there are no tasks
            setTimeout(function () {
                return q.drain();
            }, 1);

            return;
        }

        var item = {
            data: data,
            callback: typeof callback === 'function' ? callback : _noop
        };

        if (insertAtFront) {
            q._tasks.unshift(item);
        } else {
            q._tasks.push(item);
        }

        setTimeout(function () {
            return q.process();
        }, 1);
    }

    function _next(task) {
        return function next() {
            workers -= 1;

            task.callback.apply(task, arguments);

            if (arguments[0] != null) {
                // eslint-disable-line no-eq-null,eqeqeq
                q.error(arguments[0], task.data);
            }

            if (workers <= q.concurrency - q.buffer) {
                q.unsaturated();
            }

            if (q.idle()) {
                q.drain();
            }

            q.process();
        };
    }

    return q;
}

},{}],6:[function(require,module,exports){
'use strict';

exports.__esModule = true;
exports.encodeBinary = encodeBinary;
var _keyStr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';

function encodeBinary(input) {
    var output = '';
    var inx = 0;

    while (inx < input.length) {
        // Fill byte buffer array
        var bytebuffer = [0, 0, 0];
        var encodedCharIndexes = [0, 0, 0, 0];

        for (var jnx = 0; jnx < bytebuffer.length; ++jnx) {
            if (inx < input.length) {
                // throw away high-order byte, as documented at:
                // https://developer.mozilla.org/En/Using_XMLHttpRequest#Handling_binary_data
                bytebuffer[jnx] = input.charCodeAt(inx++) & 0xff;
            } else {
                bytebuffer[jnx] = 0;
            }
        }

        // Get each encoded character, 6 bits at a time
        // index 1: first 6 bits
        encodedCharIndexes[0] = bytebuffer[0] >> 2;

        // index 2: second 6 bits (2 least significant bits from input byte 1 + 4 most significant bits from byte 2)
        encodedCharIndexes[1] = (bytebuffer[0] & 0x3) << 4 | bytebuffer[1] >> 4;

        // index 3: third 6 bits (4 least significant bits from input byte 2 + 2 most significant bits from byte 3)
        encodedCharIndexes[2] = (bytebuffer[1] & 0x0f) << 2 | bytebuffer[2] >> 6;

        // index 3: forth 6 bits (6 least significant bits from input byte 3)
        encodedCharIndexes[3] = bytebuffer[2] & 0x3f;

        // Determine whether padding happened, and adjust accordingly
        var paddingBytes = inx - (input.length - 1);

        switch (paddingBytes) {
            case 2:
                // Set last 2 characters to padding char
                encodedCharIndexes[3] = 64;
                encodedCharIndexes[2] = 64;
                break;

            case 1:
                // Set last character to padding char
                encodedCharIndexes[3] = 64;
                break;

            default:
                break; // No padding - proceed
        }

        // Now we will grab each appropriate character out of our keystring
        // based on our index array and append it to the output string
        for (var _jnx = 0; _jnx < encodedCharIndexes.length; ++_jnx) {
            output += _keyStr.charAt(encodedCharIndexes[_jnx]);
        }
    }

    return output;
}

},{}],7:[function(require,module,exports){
'use strict';

var _Loader = require('./Loader');

var _Loader2 = _interopRequireDefault(_Loader);

var _Resource = require('./Resource');

var _Resource2 = _interopRequireDefault(_Resource);

var _async = require('./async');

var async = _interopRequireWildcard(_async);

var _b = require('./b64');

var b64 = _interopRequireWildcard(_b);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

_Loader2.default.Resource = _Resource2.default;
_Loader2.default.async = async;
_Loader2.default.base64 = b64;

module.exports = _Loader2.default; // eslint-disable-line no-undef

},{"./Loader":3,"./Resource":4,"./async":5,"./b64":6}]},{},[7])(7)
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
