/*!
* rete-vue-render-plugin v1.0.0-rc2 
* (c) 2021 Vitaliy Stoliarov 
* Released under the MIT license.
*/
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue')) :
  typeof define === 'function' && define.amd ? define(['exports', 'vue'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.VueRenderPlugin = {}, global.Vue));
}(this, (function (exports, vue) { 'use strict';

  function ___$insertStylesToHeader(css) {
    if (!css) {
      return
    }
    if (typeof window === 'undefined') {
      return
    }

    const style = document.createElement('style');

    style.setAttribute('type', 'text/css');
    style.innerHTML = css;
    document.head.appendChild(style);
    return css
  }

  function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
      var info = gen[key](arg);
      var value = info.value;
    } catch (error) {
      reject(error);
      return;
    }

    if (info.done) {
      resolve(value);
    } else {
      Promise.resolve(value).then(_next, _throw);
    }
  }

  function _asyncToGenerator(fn) {
    return function () {
      var self = this,
          args = arguments;
      return new Promise(function (resolve, reject) {
        var gen = fn.apply(self, args);

        function _next(value) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
        }

        function _throw(err) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
        }

        _next(undefined);
      });
    };
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? Object(arguments[i]) : {};
      var ownKeys = Object.keys(source);

      if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }

      ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }

    return target;
  }

  var Mixin = {
    props: ['node', 'editor', 'bindSocket', 'bindControl'],
    methods: {
      inputs: function inputs() {
        return Array.from(this.node.inputs.values());
      },
      outputs: function outputs() {
        return Array.from(this.node.outputs.values());
      },
      controls: function controls() {
        return Array.from(this.node.controls.values());
      },
      selected: function selected() {
        return this.editor.selected.contains(this.node) ? 'selected' : '';
      }
    },
    directives: {
      socket: {
        beforeMount: function beforeMount(el, binding) {
          binding.instance.bindSocket(el, binding.arg, binding.value);
        },
        updated: function updated(el, binding) {
          binding.instance.bindSocket(el, binding.arg, binding.value);
        }
      },
      control: {
        beforeMount: function beforeMount(el, binding) {
          if (!binding.value) return;
          binding.instance.bindControl(el, binding.value);
        }
      }
    }
  };

  function kebab(str) {
    var replace = function replace(s) {
      return s.toLowerCase().replace(/ /g, '-');
    };

    return Array.isArray(str) ? str.map(replace) : replace(str);
  }

  var script$1 = vue.defineComponent({
    props: ["type", "socket"],
    setup(props) {
      const className = vue.computed(() => {
        return kebab([props.type, props.socket.name]);
      });
      return {
        className
      };
    }
  });

  const _withId$1 = /*#__PURE__*/vue.withScopeId("data-v-51f75f2c");

  const render$1 = /*#__PURE__*/_withId$1((_ctx, _cache, $props, $setup, $data, $options) => {
    return (vue.openBlock(), vue.createBlock("div", {
      class: ["socket", _ctx.className],
      title: _ctx.socket.name
    }, null, 10 /* CLASS, PROPS */, ["title"]))
  });

  ___$insertStylesToHeader(".socket[data-v-51f75f2c] {\n  display: inline-block;\n  cursor: pointer;\n  border: 1px solid white;\n  border-radius: 12px;\n  width: 24px;\n  height: 24px;\n  margin: 6px;\n  vertical-align: middle;\n  background: #96b38a;\n  z-index: 2;\n  box-sizing: border-box;\n}\n.socket[data-v-51f75f2c][data-v-51f75f2c]:hover {\n  border-width: 4px;\n}\n.socket[data-v-51f75f2c].multiple[data-v-51f75f2c] {\n  border-color: yellow;\n}\n.socket[data-v-51f75f2c].output[data-v-51f75f2c] {\n  margin-right: -12px;\n}\n.socket[data-v-51f75f2c].input[data-v-51f75f2c] {\n  margin-left: -12px;\n}");

  script$1.render = render$1;
  script$1.__scopeId = "data-v-51f75f2c";
  script$1.__file = "src/Socket.vue";

  var script = vue.defineComponent({
    name: "node",
    components: {
      Socket: script$1
    },
    mixins: [Mixin],
    setup(props) {
      const selected = () => {
        return props.editor.selected.contains(props.node) ? "selected" : "";
      };
      const className = vue.computed(() => {
        return kebab([selected(), props.node.name]);
      });

      return { className };
    }
  });

  const _withId = /*#__PURE__*/vue.withScopeId("data-v-f9277b0a");

  vue.pushScopeId("data-v-f9277b0a");
  const _hoisted_1 = { class: "title" };
  const _hoisted_2 = { class: "output-title" };
  const _hoisted_3 = { class: "input-control" };
  vue.popScopeId();

  const render = /*#__PURE__*/_withId((_ctx, _cache, $props, $setup, $data, $options) => {
    const _component_Socket = vue.resolveComponent("Socket");
    const _directive_socket = vue.resolveDirective("socket");
    const _directive_control = vue.resolveDirective("control");

    return (vue.openBlock(), vue.createBlock("div", {
      class: ["node", _ctx.className]
    }, [
      vue.createVNode("div", _hoisted_1, vue.toDisplayString(_ctx.node.name), 1 /* TEXT */),
      vue.createCommentVNode(" Outputs"),
      (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(_ctx.outputs(), (output) => {
        return (vue.openBlock(), vue.createBlock("div", {
          class: "output",
          key: output.key
        }, [
          vue.createVNode("div", _hoisted_2, vue.toDisplayString(output.name), 1 /* TEXT */),
          vue.withDirectives(vue.createVNode(_component_Socket, {
            type: "output",
            socket: output.socket
          }, null, 8 /* PROPS */, ["socket"]), [
            [_directive_socket, output, "output"]
          ])
        ]))
      }), 128 /* KEYED_FRAGMENT */)),
      vue.createCommentVNode(" Controls"),
      (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(_ctx.controls(), (control) => {
        return vue.withDirectives((vue.openBlock(), vue.createBlock("div", {
          class: "control",
          key: control.key
        }, null, 512 /* NEED_PATCH */)), [
          [_directive_control, control]
        ])
      }), 128 /* KEYED_FRAGMENT */)),
      vue.createCommentVNode(" Inputs"),
      (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(_ctx.inputs(), (input) => {
        return (vue.openBlock(), vue.createBlock("div", {
          class: "input",
          key: input.key
        }, [
          vue.withDirectives(vue.createVNode(_component_Socket, {
            type: "input",
            socket: input.socket
          }, null, 8 /* PROPS */, ["socket"]), [
            [_directive_socket, input, "input"]
          ]),
          vue.withDirectives(vue.createVNode("div", { class: "input-title" }, vue.toDisplayString(input.name), 513 /* TEXT, NEED_PATCH */), [
            [vue.vShow, !input.showControl()]
          ]),
          vue.withDirectives(vue.createVNode("div", _hoisted_3, null, 512 /* NEED_PATCH */), [
            [vue.vShow, input.showControl()],
            [_directive_control, input.control]
          ])
        ]))
      }), 128 /* KEYED_FRAGMENT */))
    ], 2 /* CLASS */))
  });

  ___$insertStylesToHeader(".node[data-v-f9277b0a] {\n  background: rgba(110, 136, 255, 0.8);\n  border: 2px solid #4e58bf;\n  border-radius: 10px;\n  cursor: pointer;\n  min-width: 180px;\n  height: auto;\n  padding-bottom: 6px;\n  box-sizing: content-box;\n  position: relative;\n  user-select: none;\n}\n.node[data-v-f9277b0a][data-v-f9277b0a]:hover {\n  background: rgba(130, 153, 255, 0.8);\n}\n.node[data-v-f9277b0a].selected[data-v-f9277b0a] {\n  background: #ffd92c;\n  border-color: #e3c000;\n}\n.node[data-v-f9277b0a] .title[data-v-f9277b0a] {\n  color: white;\n  font-family: sans-serif;\n  font-size: 18px;\n  padding: 8px;\n}\n.node[data-v-f9277b0a] .output[data-v-f9277b0a] {\n  text-align: right;\n}\n.node[data-v-f9277b0a] .input[data-v-f9277b0a] {\n  text-align: left;\n}\n.node[data-v-f9277b0a] .input-title[data-v-f9277b0a], .node[data-v-f9277b0a] .output-title[data-v-f9277b0a] {\n  vertical-align: middle;\n  color: white;\n  display: inline-block;\n  font-family: sans-serif;\n  font-size: 14px;\n  margin: 6px;\n  line-height: 24px;\n}\n.node[data-v-f9277b0a] .input-control[data-v-f9277b0a] {\n  z-index: 1;\n  width: calc(100% - 36px);\n  vertical-align: middle;\n  display: inline-block;\n}\n.node[data-v-f9277b0a] .control[data-v-f9277b0a] {\n  padding: 6px 18px;\n}");

  script.render = render;
  script.__scopeId = "data-v-f9277b0a";
  script.__file = "src/Node.vue";

  function createVue(el, vueComponent, vueProps) {
    var node = arguments.length > 4 ? arguments[4] : undefined;
    var app = vue.createApp(vueComponent, vueProps);
    node.vueContext = app.mount(el);
    return app;
  }

  function createNode(editor, CommonVueComponent, _ref, options) {
    var el = _ref.el,
        node = _ref.node,
        component = _ref.component,
        bindSocket = _ref.bindSocket,
        bindControl = _ref.bindControl;
    var vueComponent = component.component || CommonVueComponent || script;

    var vueProps = _objectSpread({}, component.props, {
      node: node,
      editor: editor,
      bindSocket: bindSocket,
      bindControl: bindControl
    });

    return createVue(el, vueComponent, vueProps, options, node);
  }

  function createControl(editor, _ref2, options) {
    var el = _ref2.el,
        control = _ref2.control;
    var vueComponent = control.component;

    var vueProps = _objectSpread({}, control.props, {
      getData: control.getData.bind(control),
      putData: control.putData.bind(control)
    });

    return createVue(el, vueComponent, vueProps, options, control);
  }

  var update = function update(entity) {
    return new Promise(function (res) {
      if (!entity.vueContext) return res();
      entity.vueContext.$forceUpdate();
      entity.vueContext.$nextTick(res);
    });
  };

  function install(editor, _ref3) {
    var CommonVueComponent = _ref3.component,
        options = _ref3.options;
    editor.on('rendernode', function (_ref4) {
      var el = _ref4.el,
          node = _ref4.node,
          component = _ref4.component,
          bindSocket = _ref4.bindSocket,
          bindControl = _ref4.bindControl;
      if (component.render && component.render !== 'vue') return;
      node._vue = createNode(editor, CommonVueComponent, {
        el: el,
        node: node,
        component: component,
        bindSocket: bindSocket,
        bindControl: bindControl
      }, options);
      node.update = /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return update(node);

              case 2:
                return _context.abrupt("return", _context.sent);

              case 3:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));
    });
    editor.on('rendercontrol', function (_ref6) {
      var el = _ref6.el,
          control = _ref6.control;
      if (control.render && control.render !== 'vue') return;
      control._vue = createControl(editor, {
        el: el,
        control: control
      }, options);
      control.update = /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return update(control);

              case 2:
                return _context2.abrupt("return", _context2.sent);

              case 3:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));
    });
    editor.on('connectioncreated connectionremoved', function (connection) {
      update(connection.output.node);
      update(connection.input.node);
    });
    editor.on('nodeselected', function () {
      editor.nodes.map(update);
    });
  }

  var index = {
    name: 'vue-render',
    install: install,
    Node: script,
    Socket: script$1
  };

  exports['default'] = index;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=vue-render-plugin.min.js.map
