'use strict';

var UNNAMED = /import\s*['"]([^'"]+)['"];?/gi;
var NAMED = /import\s*(\{?)([\s\S]*?)\}?\s*from\s*['"]([^'"]+)['"];?/gi;

function alias(key) {
	key = key.trim();
	var name = key.split(' as ');
	(name.length > 1) && (key=name.shift());
	return { key: key, name:name[0] };
}

function single(key, dep) {
	return ("const " + (alias(key).name) + " = require('" + dep + "');");
}

function multi(keys, dep) {
	var tmp = dep.split('/').pop().replace(/\W/g, '_') + '$1'; // uniqueness
	var obj, out = single(tmp, dep);
	keys.split(',').forEach(function (key) {
		obj = alias(key);
		out += "\nconst " + (obj.name) + " = " + tmp + "." + (obj.key) + ";";
	});
	return out;
}

module.exports = function (str) {
	return str
		.replace(NAMED, function (_, bracket, req, dep) { return bracket ? multi(req, dep) : single(req, dep); })
		.replace(UNNAMED, function (_, dep) { return ("require('" + dep + "');"); });
}
