import Mark from "./Mark";
export default class MathInline extends Mark {
    get name(): string;
    get schema(): {
        group: string;
        content: string;
        inline: boolean;
        atom: boolean;
        toDOM: () => (string | number | {
            class: string;
        })[];
        parseDOM: {
            tag: string;
        }[];
    };
    inputRules({ schema }: {
        schema: any;
    }): import("prosemirror-inputrules").InputRule<any>[];
    keys({ type, schema }: {
        type: any;
        schema: any;
    }): {
        "Mod-Space": import("prosemirror-commands").Command<any>;
        Backspace: import("prosemirror-commands").Command<any>;
    };
    get plugins(): import("prosemirror-state").Plugin<import("@benrbray/prosemirror-math").IMathPluginState, any>[];
    get toMarkdown(): {
        open: string;
        close: string;
        mixable: boolean;
        expelEnclosingWhitespace: boolean;
    };
    parseMarkdown(): {
        mark: string;
    };
}
//# sourceMappingURL=MathInline.d.ts.map